/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static File getFileByPath(String filePath) {
        return StringUtils.isBlank((CharSequence)filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean isDir(String dirPath) {
        return FileUtils.isDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return FileUtils.isFileExists(file) && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtils.isFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return FileUtils.isFileExists(file) && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isFile() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtils.deleteDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !FileUtils.deleteFile(file) : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtils.deleteFile(FileUtils.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtils.deleteFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !FileUtils.deleteFile(file) : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        if (isRecursive) {
            return FileUtils.listFilesInDir(dir);
        }
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        Collections.addAll(list, dir.listFiles());
        return list;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static List<File> listFilesInDir(File dir) {
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                list.add(file);
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDir(file));
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), suffix, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix, boolean isRecursive) {
        if (isRecursive) {
            return FileUtils.listFilesInDirWithFilter(dir, suffix);
        }
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!file.getName().toUpperCase().endsWith(suffix.toUpperCase())) continue;
                list.add(file);
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), suffix);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix) {
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.getName().toUpperCase().endsWith(suffix.toUpperCase())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, suffix));
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter, boolean isRecursive) {
        if (isRecursive) {
            return FileUtils.listFilesInDirWithFilter(dir, filter);
        }
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file.getParentFile(), file.getName())) continue;
                list.add(file);
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter) {
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (filter.accept(file.getParentFile(), file.getName())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, filter));
            }
        }
        return list;
    }

    public static List<File> searchFileInDir(String dirPath, String fileName) {
        return FileUtils.searchFileInDir(FileUtils.getFileByPath(dirPath), fileName);
    }

    public static List<File> searchFileInDir(File dir, String fileName) {
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.getName().toUpperCase().equals(fileName.toUpperCase())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.searchFileInDir(file, fileName));
            }
        }
        return list;
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return FileUtils.writeFileFromString(FileUtils.getFileByPath(filePath), content, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        boolean bl;
        if (file == null || content == null) {
            return false;
        }
        if (!FileUtils.createOrExistsFile(file)) {
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file, append);
            fileWriter.write(content);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(fileWriter);
                throw throwable;
            }
            FileUtils.closeIO(fileWriter);
            return bl2;
        }
        FileUtils.closeIO(fileWriter);
        return bl;
    }

    public static List<String> readFile2List(String filePath, String charsetName) {
        return FileUtils.readFile2List(FileUtils.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFile2List(File file, String charsetName) {
        return FileUtils.readFile2List(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFile2List(String filePath, int st, int end, String charsetName) {
        return FileUtils.readFile2List(FileUtils.getFileByPath(filePath), st, end, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int st, int end, String charsetName) {
        ArrayList<String> arrayList;
        if (file == null) {
            return null;
        }
        if (st > end) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = StringUtils.isBlank((CharSequence)charsetName) ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = reader.readLine()) != null && curLine <= end; ++curLine) {
                if (st > curLine || curLine > end) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (IOException e) {
            List<String> list;
            try {
                e.printStackTrace();
                list = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(reader);
                throw throwable;
            }
            FileUtils.closeIO(reader);
            return list;
        }
        FileUtils.closeIO(reader);
        return arrayList;
    }

    public static String readFile2String(String filePath, String charsetName) {
        return FileUtils.readFile2String(FileUtils.getFileByPath(filePath), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile2String(File file, String charsetName) {
        String string;
        if (file == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            reader = StringUtils.isBlank((CharSequence)charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            string = sb.delete(sb.length() - 2, sb.length()).toString();
        }
        catch (IOException e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(reader);
                throw throwable;
            }
            FileUtils.closeIO(reader);
            return string2;
        }
        FileUtils.closeIO(reader);
        return string;
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtils.getFileCharsetSimple(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int p = 0;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (((InputStream)is).read() << 8) + ((InputStream)is).read();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(is);
                throw throwable;
            }
            FileUtils.closeIO(is);
        }
        FileUtils.closeIO(is);
        switch (p) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        try {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getDirName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getDirName(file.getPath());
    }

    public static String getDirName(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (-1 == StringUtils.indexOf((CharSequence)filePath, (CharSequence)".")) {
            return "";
        }
        String ext = StringUtils.substring((String)filePath, (int)StringUtils.lastIndexOf((CharSequence)filePath, (CharSequence)"."));
        return StringUtils.trimToEmpty((String)ext);
    }

    public static String getFilePathWithoutExtension(String filePath) {
        if (-1 == StringUtils.indexOf((CharSequence)filePath, (CharSequence)".")) {
            return "";
        }
        return StringUtils.substring((String)filePath, (int)0, (int)StringUtils.lastIndexOf((CharSequence)filePath, (CharSequence)"."));
    }
}

