/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import com.ztesoft.zsmart.nros.base.util.ExceptionUtil;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtils {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String ENCODE = "UTF-8";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static Logger logger = LoggerFactory.getLogger(EncryptUtils.class);

    public static String mergeDigest(String[] strs) {
        Objects.requireNonNull(strs);
        try {
            MessageDigest md = MessageDigest.getInstance(SHA1);
            md.update(EncryptUtils.class.getName().getBytes(ENCODE));
            for (String str : strs) {
                if (null == str) continue;
                md.update(str.getBytes(ENCODE));
            }
            return ENCODER.encodeToString(md.digest());
        }
        catch (Exception e) {
            logger.error("error occur", (Throwable)e);
            return null;
        }
    }

    public static String encryptSHA1(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        try {
            MessageDigest mdTemp = MessageDigest.getInstance(SHA1);
            mdTemp.update(str.getBytes(ENCODE));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                buf[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5f02\u5e38\uff1a", (Object)ExceptionUtil.getStackTrace(e));
            return null;
        }
    }

    public static String encryptSHA256(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(SHA256);
            messageDigest.update(str.getBytes(ENCODE));
            return EncryptUtils.byte2Hex(messageDigest.digest());
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5f02\u5e38\uff1a", (Object)ExceptionUtil.getStackTrace(e));
            return null;
        }
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] args) {
        String password = "dafasdfasd";
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            EncryptUtils.encryptSHA256(i + password + i);
        }
        long end = System.currentTimeMillis();
    }
}

