/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import com.google.common.collect.Lists;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class DateUtil {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
    public static final String NYRSF_DATESTAMP_FORMAT = "yyyyMMddHHmm";

    private DateUtil() {
    }

    public static Date getNow() {
        return Calendar.getInstance().getTime();
    }

    public static String getNow(String format) {
        return DateUtil.dateToStr(DateUtil.getNow(), format);
    }

    public static String getCurrentDate() {
        return DateUtil.getNow(DEFAULT_DATE_FORMAT);
    }

    public static String getCurrentTime() {
        return DateUtil.getNow(DEFAULT_TIME_FORMAT);
    }

    public static String getCurrentDateTime() {
        return DateUtil.getNow(DEFAULT_DATE_TIME_FORMAT);
    }

    public static Date getTomorrow() {
        return DateUtil.getEndDateByDay(DateUtil.getNow(), 1);
    }

    public static String getTomorrow(String format) {
        return DateUtil.dateToStr(DateUtil.getTomorrow(), format);
    }

    public static Date getYesterday() {
        return DateUtil.getEndDateByDay(DateUtil.getNow(), -1);
    }

    public static String getYesterday(String format) {
        return DateUtil.dateToStr(DateUtil.getYesterday(), format);
    }

    public static Date getDate(int year, int month, int day) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, month - 1, day);
        return c.getTime();
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, month - 1, day, hour, minute, second);
        return c.getTime();
    }

    public static String getCurrentYear() {
        return DateUtil.getNow("yyyy");
    }

    public static String getPreYear() {
        return DateUtil.dateToStr(DateUtil.getEndDateByYear(DateUtil.getNow(), -1), "yyyy");
    }

    public static String getNextYear() {
        return DateUtil.dateToStr(DateUtil.getEndDateByYear(DateUtil.getNow(), 1), "yyyy");
    }

    public static String getCurrentMonth() {
        return DateUtil.getNow("MM");
    }

    public static String getPreMonth() {
        return DateUtil.dateToStr(DateUtil.getEndDateByMonth(DateUtil.getNow(), -1), "MM");
    }

    public static String getNextMonth() {
        return DateUtil.dateToStr(DateUtil.getEndDateByMonth(DateUtil.getNow(), 1), "MM");
    }

    public static String getCurrentDay() {
        return DateUtil.getNow("dd");
    }

    public static String getPreDay() {
        return DateUtil.getYesterday("dd");
    }

    public static String getNextDay() {
        return DateUtil.getTomorrow("dd");
    }

    public static String dateToStr(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String dateString = dateFormat.format(date);
        return dateString;
    }

    public static String dateToStr(Date date) {
        return DateUtil.dateToStr(date, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String getTimestamp() {
        return DateUtil.dateToStr(DateUtil.getNow(), DEFAULT_DATESTAMP_FORMAT);
    }

    public static String getNyrTimestamp() {
        return DateUtil.dateToStr(DateUtil.getNow(), NYRSF_DATESTAMP_FORMAT);
    }

    public static String getTimestamp(String format) {
        return DateUtil.dateToStr(DateUtil.getNow(), format);
    }

    public static Date strToDate(String date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            ExceptionHandler.publish("Can not convert String to Date, cause: " + e.getMessage());
            return null;
        }
    }

    public static Date strToDate(String date) {
        return DateUtil.strToDate(date, DEFAULT_DATE_TIME_FORMAT);
    }

    public static Date getEndDate(Date sDate, int type, int interval) {
        Calendar sCalendar = Calendar.getInstance();
        sCalendar.setTime(sDate);
        sCalendar.add(type, interval);
        return sCalendar.getTime();
    }

    public static Date getEndDateByMilliSecond(Date sDate, int milliSecond) {
        return DateUtil.getEndDate(sDate, 14, milliSecond);
    }

    public static Date getEndDateBySecond(Date sDate, int second) {
        return DateUtil.getEndDate(sDate, 13, second);
    }

    public static Date getEndDateByMinute(Date sDate, int minute) {
        return DateUtil.getEndDate(sDate, 12, minute);
    }

    public static Date getEndDateByHour(Date sDate, int hour) {
        return DateUtil.getEndDate(sDate, 10, hour);
    }

    public static Date getEndDateByDay(Date sDate, int days) {
        return DateUtil.getEndDate(sDate, 5, days);
    }

    public static Date getEndDateByMonth(Date sDate, int monthes) {
        return DateUtil.getEndDate(sDate, 2, monthes);
    }

    public static Date getEndDateByYear(Date sDate, int years) {
        return DateUtil.getEndDate(sDate, 1, years);
    }

    public static long getDiffByMilliSecond(Date sDate, Date eDate) {
        return eDate.getTime() - sDate.getTime();
    }

    public static long getDiffBySecond(Date sDate, Date eDate) {
        return DateUtil.getDiffByMilliSecond(sDate, eDate) / 1000L;
    }

    public static long getDiffByMinute(Date sDate, Date eDate) {
        return DateUtil.getDiffBySecond(sDate, eDate) / 60L;
    }

    public static long getDiffByHour(Date sDate, Date eDate) {
        return DateUtil.getDiffByMinute(sDate, eDate) / 60L;
    }

    public static long getDiffByDay(Date sDate, Date eDate) {
        return DateUtil.getDiffByHour(sDate, eDate) / 24L;
    }

    public static long getDiffByMonth(Date sDate, Date eDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(sDate);
        Calendar end = Calendar.getInstance();
        end.setTime(eDate);
        int months = end.get(2) - start.get(2);
        int yearMonths = (end.get(1) - start.get(1)) * 12;
        return yearMonths + months;
    }

    public static int getDayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getDayOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDaysOfMonth(Date date) {
        int[] mArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (DateUtil.isLeapYear(date)) {
            mArray[1] = 29;
        }
        return mArray[DateUtil.getMonthOfYear(date) - 1];
    }

    public static int getDayOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int getWeekOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(4);
    }

    public static int getWeekOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(3);
    }

    public static int getMonthOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static String[] getSelectYear(int startYear, int endYear) {
        if (startYear > endYear || startYear < 0 || endYear < 0) {
            return new String[0];
        }
        String[] yearList = new String[endYear - startYear + 1];
        for (int i = startYear; i <= endYear; ++i) {
            yearList[i - startYear] = String.valueOf(i);
        }
        return yearList;
    }

    public static String[] getSelectMonth(int startMonth, int endMonth) {
        if (startMonth > endMonth) {
            return new String[0];
        }
        startMonth = startMonth < 0 || startMonth > 12 ? 1 : startMonth;
        endMonth = endMonth < 0 || endMonth > 12 ? 12 : endMonth;
        String[] monthList = new String[endMonth - startMonth + 1];
        for (int i = startMonth; i <= endMonth; ++i) {
            monthList[i - startMonth] = String.valueOf(i);
        }
        return monthList;
    }

    public static boolean isInRange(Date date, Date start, Date end) {
        return DateUtil.compareDate(start, date) <= 0 && DateUtil.compareDate(end, date) >= 0;
    }

    public static int compareDate(Date sDate, Date eDate) {
        Calendar sCalendar = Calendar.getInstance();
        sCalendar.setTime(sDate);
        Calendar eCalendar = Calendar.getInstance();
        eCalendar.setTime(eDate);
        return sCalendar.compareTo(eCalendar);
    }

    public static Date transformDateBetweenTimeZone(Date date, TimeZone sourceTimeZone, TimeZone targetTimeZone) {
        Long targetTime = date.getTime() - (long)sourceTimeZone.getRawOffset() + (long)targetTimeZone.getRawOffset();
        return new Date(targetTime);
    }

    public static Date transformDateBetweenTimeZone(String dateStr, String dateFormat, TimeZone sourceTimeZone, TimeZone targetTimeZone) {
        Date date = DateUtil.strToDate(dateStr, dateFormat);
        return DateUtil.transformDateBetweenTimeZone(date, sourceTimeZone, targetTimeZone);
    }

    public static String[] getAllTimeZone() {
        ArrayList v = Lists.newArrayList();
        String[] timeZones = TimeZone.getAvailableIDs();
        for (int i = 0; i < timeZones.length; ++i) {
            v.add(timeZones[i]);
        }
        Collections.sort(v, String.CASE_INSENSITIVE_ORDER);
        timeZones = v.toArray(timeZones);
        v = null;
        return timeZones;
    }

    private static boolean isLeapYear(Date date) {
        int year = Integer.valueOf(DateUtil.dateToStr(date, "yyyy"));
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static List<String> getWeekdayStrs() {
        ArrayList<String> weekDayStrs = new ArrayList<String>();
        List<Date> weekDays = DateUtil.getWeekdays();
        weekDays.forEach(weekDay -> weekDayStrs.add(DateUtil.dateToStr(weekDay, DEFAULT_DATE_FORMAT)));
        return weekDayStrs;
    }

    public static List<Date> getWeekdays() {
        ArrayList<Date> weekDays = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance();
        DateUtil.setToFirstDay(calendar);
        for (int i = 0; i < 7; ++i) {
            weekDays.add(calendar.getTime());
            calendar.add(5, 1);
        }
        return weekDays;
    }

    private static void setToFirstDay(Calendar calendar) {
        while (calendar.get(7) != 2) {
            calendar.add(5, -1);
        }
    }

    public static Date getFirstDayOfMonth(Date date) {
        return DateUtil.getFirstDayOfMonth(date, 0);
    }

    public static Date getFirstDayOfMonth(Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        calendar.set(5, 1);
        return DateUtil.getDateZero(calendar);
    }

    public static Date getDateZero(Date date) {
        return DateUtil.getDateZero(date, 0);
    }

    public static Date getDateZero(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return DateUtil.getDateZero(calendar);
    }

    private static Date getDateZero(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

