/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.ConvertExtend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ConvertUtil {
    private static Logger logger = LoggerFactory.getLogger(ConvertUtil.class);

    public static <S, T> List<T> listEntity2DTO(List<S> list, Class<T> kClass) {
        ArrayList<T> targetList = new ArrayList<T>();
        if (CollectionUtils.isEmpty(list)) {
            return targetList;
        }
        for (S s : list) {
            T t = ConvertUtil.beanCopy(s, kClass);
            targetList.add(t);
        }
        return targetList;
    }

    public static <S, T> List<T> listEntity2DTO(List<S> list, Class<T> kClass, ConvertExtend<S, T> convertExtend) {
        ArrayList<T> targetList = new ArrayList<T>();
        if (CollectionUtils.isEmpty(list)) {
            return targetList;
        }
        for (S s : list) {
            T t = ConvertUtil.beanCopy(s, kClass, convertExtend);
            targetList.add(t);
        }
        return targetList;
    }

    public static <S, T> T beanCopy(S source, Class<T> kClass) {
        T target = null;
        try {
            target = kClass.newInstance();
            if (Objects.isNull(source)) {
                return target;
            }
            BeanUtils.copyProperties(source, target);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ExceptionHandler.publish("-1", "\u5b9e\u4f53\u8f6c\u6362\u5f02\u5e38");
        }
        return target;
    }

    public static <S, T> T beanCopy(S source, Class<T> kClass, ConvertExtend<S, T> convertExtend) {
        T t = ConvertUtil.beanCopy(source, kClass);
        convertExtend.extend(source, t);
        return t;
    }

    public static <T> List<T> convertArr(String sourceArr, String regex, Class<T> targetClass) {
        String[] split = sourceArr.split(regex);
        Object[] convert = (Object[])ConvertUtils.convert((String[])split, targetClass);
        List<Object> target = Arrays.asList(convert);
        return target;
    }

    public static String getUrl(String url, Map<String, Object> params) {
        if (params != null) {
            Iterator<String> it = params.keySet().iterator();
            StringBuffer sb = null;
            while (it.hasNext()) {
                String value;
                String key = it.next();
                Object paramValue = params.get(key);
                if (null == paramValue) {
                    value = "";
                } else if (paramValue instanceof Integer) {
                    value = String.valueOf(paramValue);
                } else {
                    value = String.valueOf(paramValue);
                    value = value.replace("#", "");
                }
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(key);
                sb.append("=");
                sb.append(value);
            }
            if (sb != null) {
                url = url + sb.toString();
            }
        }
        return url;
    }
}

