/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.session;

import com.ztesoft.zsmart.nros.base.constant.BaseConstant;
import com.ztesoft.zsmart.nros.base.exception.SessionException;
import com.ztesoft.zsmart.nros.base.session.SessionUtils;
import com.ztesoft.zsmart.nros.base.util.paas.CacheUtils;
import com.ztesoft.zsmart.nros.common.session.SessionInfo;
import com.ztesoft.zsmart.nros.common.session.UserInfo;
import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SessionManager
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static ThreadLocal<SessionInfo> session = new ThreadLocal();
    @Autowired
    private CacheUtils cacheUtils;
    @Value(value="${nros.base.session.expire-time:3600}")
    private Long expireTime;

    public static SessionInfo getSession() {
        return session.get();
    }

    public static void setSession(SessionInfo sessionInfo) {
        session.set(sessionInfo);
    }

    boolean hasValidSession(HttpServletRequest request) {
        String sessionCacheKey;
        try {
            sessionCacheKey = this.getSessionCacheKey(request);
        }
        catch (SessionException e) {
            return false;
        }
        logger.info("----------------------------------------------------");
        logger.info("\u5165\u53c2\u8bf7\u6c42\u7684session\u53d6\u503c\u7684key\uff01\uff01\uff01\uff01" + sessionCacheKey);
        SessionInfo sessionInfo = this.getSessionFromCache(sessionCacheKey);
        if (null == sessionInfo) {
            return false;
        }
        SessionManager.setSession(sessionInfo);
        return true;
    }

    String getSessionCacheKey(HttpServletRequest request) throws SessionException {
        if (null == this.getSessionId(request)) {
            throw new SessionException();
        }
        return "nrosportal9.1.7:sessions:" + this.getSessionId(request);
    }

    String getSessionId(HttpServletRequest request) {
        return request.getRequestedSessionId();
    }

    boolean hasValidSessionBySessionId(String sessionId) {
        String sessionCacheKey = "nrosportal9.1.7:sessions:" + sessionId;
        SessionInfo sessionInfo = this.getSessionFromCache(sessionCacheKey);
        if (null == sessionInfo) {
            return false;
        }
        SessionManager.setSession(sessionInfo);
        return true;
    }

    boolean hasValidSessionByUserId(String userId) {
        String sessionCacheKey = BaseConstant.API_USER_ID_PREFIX + userId;
        SessionInfo sessionInfo = this.getSessionFromCache(sessionCacheKey);
        if (null == sessionInfo) {
            return false;
        }
        SessionManager.setSession(sessionInfo);
        return true;
    }

    void removeLocalSession() {
        SessionManager.setSession(null);
    }

    SessionInfo getSessionInfo() throws SessionException {
        return SessionManager.getSession();
    }

    public SessionInfo getSessionFromCache(String sessionCacheKey) {
        String userId;
        Object result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:USER_ID");
        if (null != result && StringUtils.isNotEmpty((String)(userId = result.toString()))) {
            logger.info("----------------------------------------------------");
            this.cacheUtils.setExpireTime(sessionCacheKey, this.expireTime);
            logger.info("----------------------------------------------------");
            SessionInfo sessionInfo = new SessionInfo();
            UserInfo userInfo = new UserInfo();
            Object userCode = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:USER_CODE");
            if (null != result) {
                userInfo.setUserCode(userCode.toString());
            }
            if (null != (result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:USER_ID"))) {
                userInfo.setUserId(Long.valueOf(result.toString()));
                sessionInfo.setUserId(Long.valueOf(result.toString()));
            }
            if (null != (result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:USER_NAME"))) {
                userInfo.setUserName(result.toString());
            }
            if (null != (result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:STAFF_ID"))) {
                sessionInfo.setStaffId(result.toString());
            }
            sessionInfo.setUserInfo(userInfo);
            sessionInfo.setStoreIds("5,50000,50314,50518");
            return sessionInfo;
        }
        logger.warn("Failed to get session info from tair, key: " + sessionCacheKey + ", result: " + result);
        return null;
    }

    public SessionInfo getOriginalSessionFromCache(String sessionCacheKey) {
        if (!this.cacheUtils.exists(sessionCacheKey)) {
            return null;
        }
        this.cacheUtils.setExpireTime(sessionCacheKey, this.expireTime);
        SessionInfo sessionInfo = new SessionInfo();
        UserInfo userInfo = new UserInfo();
        Object result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:USER_CODE");
        if (null != result) {
            userInfo.setUserCode(result.toString());
        }
        if (null != (result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:USER_ID"))) {
            userInfo.setUserId(Long.valueOf(result.toString()));
            sessionInfo.setUserId(Long.valueOf(result.toString()));
        }
        if (null != (result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:USER_NAME"))) {
            userInfo.setUserName(result.toString());
        }
        if (null != (result = this.cacheUtils.hmGet(sessionCacheKey, "sessionAttr:STAFF_ID"))) {
            sessionInfo.setStaffId(result.toString());
        }
        sessionInfo.setStoreIds("5,50000,50314,50518");
        sessionInfo.setUserInfo(userInfo);
        return sessionInfo;
    }

    public void afterPropertiesSet() throws Exception {
        SessionUtils.inject(this);
    }

    public void updateSessionLastAccessTime(String sessionId) {
        String sessionCacheKey = "nrosportal9.1.7:sessions:" + sessionId;
        Object result = this.cacheUtils.hmGet(sessionCacheKey, "lastAccessedTime");
        if (null != result) {
            Long lastAccessedTime = Instant.now().toEpochMilli();
            this.cacheUtils.hmSet(sessionCacheKey, "lastAccessedTime", lastAccessedTime);
            return;
        }
        logger.warn("Failed to update session lastAccessedTime, key: " + sessionCacheKey + ", result: " + result);
    }

    boolean hasValidOriginalSession(String sessionId) {
        String sessionCacheKey = "nrosportal9.1.7:sessions:" + sessionId;
        SessionInfo sessionInfo = this.getOriginalSessionFromCache(sessionCacheKey);
        if (null == sessionInfo) {
            return false;
        }
        sessionInfo.setSessionId(sessionId);
        SessionManager.setSession(sessionInfo);
        return true;
    }

    public CacheUtils getCacheUtils() {
        return this.cacheUtils;
    }

    public Long getExpireTime() {
        return this.expireTime;
    }

    public void setCacheUtils(CacheUtils cacheUtils) {
        this.cacheUtils = cacheUtils;
    }

    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionManager)) {
            return false;
        }
        SessionManager other = (SessionManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CacheUtils this$cacheUtils = this.getCacheUtils();
        CacheUtils other$cacheUtils = other.getCacheUtils();
        if (this$cacheUtils == null ? other$cacheUtils != null : !this$cacheUtils.equals(other$cacheUtils)) {
            return false;
        }
        Long this$expireTime = this.getExpireTime();
        Long other$expireTime = other.getExpireTime();
        return !(this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CacheUtils $cacheUtils = this.getCacheUtils();
        result = result * 59 + ($cacheUtils == null ? 43 : $cacheUtils.hashCode());
        Long $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        return result;
    }

    public String toString() {
        return "SessionManager(cacheUtils=" + this.getCacheUtils() + ", expireTime=" + this.getExpireTime() + ")";
    }
}

