/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.ztesoft.zsmart.nros.base.session.SessionUtils;
import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.base.util.RuntimeContext;
import com.ztesoft.zsmart.nros.common.model.enums.StatusEnum;
import com.ztesoft.zsmart.nros.common.session.SessionInfo;
import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AutoInFieldInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoInFieldInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object object = invocation.getArgs()[1];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (SqlCommandType.INSERT.equals((Object)sqlCommandType)) {
            if (null == AutoInFieldInterceptor.getFieldValue(object, "gmtCreate")) {
                AutoInFieldInterceptor.setFieldValue(object, "gmtCreate", DateUtil.getNow());
            }
            AutoInFieldInterceptor.setFieldValue(object, "gmtModified", DateUtil.getNow());
            AutoInFieldInterceptor.setFieldValue(object, "creator", this.getOperatorJson());
            if (null == AutoInFieldInterceptor.getFieldValue(object, "status")) {
                AutoInFieldInterceptor.setFieldValue(object, "status", StatusEnum.ENABLE.getState());
            }
        } else if (SqlCommandType.UPDATE.equals((Object)sqlCommandType)) {
            AutoInFieldInterceptor.setFieldValue(object, "gmtModified", DateUtil.getNow());
            AutoInFieldInterceptor.setFieldValue(object, "modifier", this.getOperatorJson());
        }
        return invocation.proceed();
    }

    private JSONObject getOperatorJson() {
        JSONObject operatorJson = new JSONObject();
        String userId = RuntimeContext.getValue("user_id");
        String userName = RuntimeContext.getValue("user_name");
        if (StringUtils.isBlank((CharSequence)userId) && StringUtils.isBlank((CharSequence)userName)) {
            SessionInfo sessionInfo = SessionUtils.getSessionInfo();
            if (null != sessionInfo) {
                operatorJson.put("user_id", (Object)(sessionInfo.getUserId() + ""));
                operatorJson.put("user_name", (Object)sessionInfo.getUserInfo().getUserName());
            } else {
                operatorJson.put("user_id", (Object)"");
                operatorJson.put("user_name", (Object)"--");
            }
        } else {
            operatorJson.put("user_id", (Object)userId);
            operatorJson.put("user_name", (Object)userName);
        }
        return operatorJson;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private static void setFieldValue(Object clazz, String fieldName, Object value) {
        if (clazz == null) {
            return;
        }
        try {
            Field field = clazz.getClass().getField(fieldName);
            field.setAccessible(true);
            field.set(clazz, value);
        }
        catch (Exception e) {
            LOGGER.info(clazz.getClass() + "\u4e0d\u5b58\u5728field:" + fieldName);
        }
    }

    private static Object getFieldValue(Object clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getClass().getField(fieldName);
            field.setAccessible(true);
            Object value = field.get(clazz);
            return value;
        }
        catch (Exception e) {
            LOGGER.info(clazz.getClass() + "\u4e0d\u5b58\u5728field:" + fieldName);
            return null;
        }
    }
}

