/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.exception;

import com.ztesoft.zsmart.nros.base.exception.AppSecretException;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.exception.SessionException;
import com.ztesoft.zsmart.nros.base.i18n.I18nUtils;
import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import feign.FeignException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExHandler.class);

    @ExceptionHandler(value={BusiException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public <T> ResponseMsg<T> handleAllException(BusiException e, HttpServletRequest request) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        return ResponseMsg.buildFail(e.getErrorCode(), e.getMessage());
    }

    @ExceptionHandler(value={SessionException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public <T> ResponseMsg<T> handleSessionExpiredException(SessionException e, HttpServletRequest request) {
        LOGGER.error(e.getErrorMsg(), (Throwable)e);
        return ResponseMsg.buildFail(e.getErrorCode(), e.getMessage());
    }

    @ExceptionHandler(value={AppSecretException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public <T> ResponseMsg<T> handleAppSecretException(AppSecretException e, HttpServletRequest request) {
        LOGGER.error(e.getErrorMsg(), (Throwable)e);
        return ResponseMsg.buildFail(e.getErrorCode() + "", e.getMessage());
    }

    @ExceptionHandler(value={FeignException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public <T> ResponseMsg<T> handleFeignException(FeignException e, HttpServletRequest request) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        return ResponseMsg.buildFail(e.status() + "", e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public <T> ResponseMsg<T> throwable(Exception e, HttpServletRequest request) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        return ResponseMsg.buildFail("-1", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseMsg methodArgumentNotValidExceptionHandler(Exception ex, HttpServletRequest request) {
        String msgCode = "PARAM CHECK ERROR";
        String msgDesc = "";
        if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException mve = (MethodArgumentNotValidException)ex;
            BindingResult bindingResult = mve.getBindingResult();
            List messageList = bindingResult.getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
            List globalizationMessage = messageList.stream().map(I18nUtils::getMessage).collect(Collectors.toList());
            msgDesc = String.join((CharSequence)";", globalizationMessage);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)((Object)ex);
            List messageList = cve.getConstraintViolations().stream().map(ee -> ee.getMessage()).collect(Collectors.toList());
            msgDesc = messageList.stream().map(I18nUtils::getMessage).collect(Collectors.joining(";"));
        }
        return ResponseMsg.buildFail(msgCode, msgDesc);
    }
}

