/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.exception;

import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.i18n.I18nUtils;
import com.ztesoft.zsmart.nros.base.util.StringUtil;

public class ExceptionHandler {
    public static void publish(String errorCode) throws BusiException {
        ExceptionHandler.publish(errorCode, "", null, null);
    }

    public static void publish(String errorCode, String errorMsg) throws BusiException {
        ExceptionHandler.publish(errorCode, errorMsg, null, null);
    }

    public static void publish(String errorCode, String errorMsg, String ... params) throws BusiException {
        ExceptionHandler.publish(errorCode, errorMsg, null, (Object[])params);
    }

    public static void publish(String errorCode, String errorMsg, Throwable t) throws BusiException {
        ExceptionHandler.publish(errorCode, errorMsg, t, null);
    }

    public static void publish(String errorCode, String errorMsg, Throwable t, Object[] params) throws BusiException {
        BusiException be;
        if (t != null && t instanceof BusiException) {
            be = (BusiException)t;
        } else {
            String i18nErrorMsg = I18nUtils.getMessage(errorCode, params);
            if (StringUtil.isNotNull(i18nErrorMsg) && !i18nErrorMsg.equals(errorCode)) {
                errorMsg = i18nErrorMsg;
            }
            be = new BusiException(errorCode, errorMsg, t);
        }
        throw be;
    }
}

