/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.exception;

import java.io.Serializable;

public class AppSecretException
extends RuntimeException
implements Serializable {
    private Integer errorCode;
    private String errorMsg;

    public AppSecretException() {
    }

    public AppSecretException(String message) {
        this(null, message, null);
    }

    public AppSecretException(Integer errorCode, String message) {
        this(errorCode, message, null);
    }

    public AppSecretException(Integer errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        this.errorMsg = message;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.errorCode != null) {
            sb.append("errorCode = [");
            sb.append(this.errorCode);
            sb.append("]");
            if (this.errorMsg != null) {
                sb.append("  errorDesc= [");
                sb.append(this.errorMsg);
                sb.append("]");
            }
        }
        for (int i = 0; i < this.getStackTrace().length; ++i) {
            sb.append("\r\n\tat ");
            sb.append(this.getStackTrace()[i]);
        }
        Throwable cause = this.getCause();
        while (cause != null) {
            sb.append("\r\nCause by: ");
            sb.append(cause.toString());
            for (int i = 0; i < cause.getStackTrace().length; ++i) {
                sb.append("\r\n\tat ");
                sb.append(cause.getStackTrace()[i]);
            }
            if ((cause = cause.getCause()) == null) continue;
            sb.append("\r\nCaused by: ");
        }
        return sb.toString();
    }
}

