/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.config;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestConfig {
    @Bean
    @ConditionalOnMissingBean(value={RestOperations.class, RestTemplate.class})
    public RestTemplate restOperations() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setReadTimeout(5000);
        requestFactory.setConnectTimeout(5000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        List messageConverters = restTemplate.getMessageConverters();
        Iterator iterator = messageConverters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter converter = (HttpMessageConverter)iterator.next();
            if (!(converter instanceof StringHttpMessageConverter)) continue;
            iterator.remove();
        }
        messageConverters.add(1, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        return restTemplate;
    }
}

