/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.executor.impl;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.glue.GlueFactory;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.handler.impl.MethodJobHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;

public class XxlJobSpringExecutor
extends XxlJobExecutor
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static ApplicationContext applicationContext;

    public void afterPropertiesSet() throws Exception {
        this.initJobHandlerRepository(applicationContext);
        this.initJobHandlerMethodRepository(applicationContext);
        GlueFactory.refreshInstance(1);
        super.start();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private void initJobHandlerRepository(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map serviceBeanMap = applicationContext.getBeansWithAnnotation(JobHandler.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (!(serviceBean instanceof IJobHandler)) continue;
                String name = serviceBean.getClass().getAnnotation(JobHandler.class).value();
                IJobHandler handler = (IJobHandler)serviceBean;
                if (XxlJobSpringExecutor.loadJobHandler(name) != null) {
                    throw new RuntimeException("xxl-job jobhandler[" + name + "] naming conflicts.");
                }
                XxlJobSpringExecutor.registJobHandler(name, handler);
            }
        }
    }

    private void initJobHandlerMethodRepository(ApplicationContext applicationContext) {
        String[] beanDefinitionNames;
        if (applicationContext == null) {
            return;
        }
        for (String beanDefinitionName : beanDefinitionNames = applicationContext.getBeanDefinitionNames()) {
            Method[] methods;
            Object bean = applicationContext.getBean(beanDefinitionName);
            for (Method method : methods = bean.getClass().getDeclaredMethods()) {
                XxlJob xxlJob = (XxlJob)AnnotationUtils.findAnnotation((Method)method, XxlJob.class);
                if (xxlJob == null) continue;
                String name = xxlJob.value();
                if (name.trim().length() == 0) {
                    throw new RuntimeException("xxl-job method-jobhandler name invalid, for[" + bean.getClass() + "#" + method.getName() + "] .");
                }
                if (XxlJobSpringExecutor.loadJobHandler(name) != null) {
                    throw new RuntimeException("xxl-job jobhandler[" + name + "] naming conflicts.");
                }
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(String.class)) {
                    throw new RuntimeException("xxl-job method-jobhandler param-classtype invalid, for[" + bean.getClass() + "#" + method.getName() + "] , The correct method format like \" public ReturnT<String> execute(String param) \" .");
                }
                if (!method.getReturnType().isAssignableFrom(ReturnT.class)) {
                    throw new RuntimeException("xxl-job method-jobhandler return-classtype invalid, for[" + bean.getClass() + "#" + method.getName() + "] , The correct method format like \" public ReturnT<String> execute(String param) \" .");
                }
                method.setAccessible(true);
                Method initMethod = null;
                Method destroyMethod = null;
                if (xxlJob.init().trim().length() > 0) {
                    try {
                        initMethod = bean.getClass().getDeclaredMethod(xxlJob.init(), new Class[0]);
                        initMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("xxl-job method-jobhandler initMethod invalid, for[" + bean.getClass() + "#" + method.getName() + "] .");
                    }
                }
                if (xxlJob.destroy().trim().length() > 0) {
                    try {
                        destroyMethod = bean.getClass().getDeclaredMethod(xxlJob.destroy(), new Class[0]);
                        destroyMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("xxl-job method-jobhandler destroyMethod invalid, for[" + bean.getClass() + "#" + method.getName() + "] .");
                    }
                }
                XxlJobSpringExecutor.registJobHandler(name, new MethodJobHandler(bean, method, initMethod, destroyMethod));
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        XxlJobSpringExecutor.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

