/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.rpc.netcom.jetty.server;

import com.xxl.job.core.rpc.netcom.jetty.server.JettyServerHandler;
import com.xxl.job.core.thread.ExecutorRegistryThread;
import com.xxl.job.core.thread.TriggerCallbackThread;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private Server server;
    private Thread thread;

    public void start(final int port, final String ip, final String appName) throws Exception {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JettyServer.this.server = new Server((ThreadPool)new ExecutorThreadPool());
                ServerConnector connector = new ServerConnector(JettyServer.this.server);
                if (ip != null && ip.trim().length() > 0) {
                    connector.setHost(ip);
                }
                connector.setPort(port);
                JettyServer.this.server.setConnectors(new Connector[]{connector});
                HandlerCollection handlerc = new HandlerCollection();
                handlerc.setHandlers(new Handler[]{new JettyServerHandler()});
                JettyServer.this.server.setHandler((Handler)handlerc);
                try {
                    JettyServer.this.server.start();
                    logger.info(">>>>>>>>>>>> xxl-job jetty server start success at port:{}.", (Object)port);
                    ExecutorRegistryThread.getInstance().start(port, ip, appName);
                    TriggerCallbackThread.getInstance().start();
                    JettyServer.this.server.join();
                    logger.info(">>>>>>>>>>> xxl-rpc server join success, netcon={}, port={}", (Object)JettyServer.class.getName(), (Object)port);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void destroy() {
        ExecutorRegistryThread.getInstance().toStop();
        TriggerCallbackThread.getInstance().toStop();
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
        logger.info(">>>>>>>>>>> xxl-rpc server destroy success, netcon={}", (Object)JettyServer.class.getName());
    }
}

