/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.log;

import com.xxl.job.core.log.XxlJobFileAppender;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobLogger {
    private static Logger logger = LoggerFactory.getLogger((String)"xxl-job logger");
    private static SimpleDateFormat xxlJobLoggerFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void log(String appendLog) {
        String logFileName = (String)XxlJobFileAppender.contextHolder.get();
        if (logFileName == null || logFileName.trim().length() == 0) {
            return;
        }
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        StackTraceElement callInfo = stackTraceElements[1];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(xxlJobLoggerFormat.format(new Date())).append(" ").append("[" + callInfo.getClassName() + "]").append("-").append("[" + callInfo.getMethodName() + "]").append("-").append("[" + callInfo.getLineNumber() + "]").append("-").append("[" + Thread.currentThread().getName() + "]").append(" ").append(appendLog != null ? appendLog : "");
        String formatAppendLog = stringBuffer.toString();
        XxlJobFileAppender.appendLog(logFileName, formatAppendLog);
        logger.warn("[{}]: {}", (Object)logFileName, (Object)formatAppendLog);
    }

    public static void log(String appendLogPattern, Object ... appendLogArguments) {
        String appendLog = MessageFormat.format(appendLogPattern, appendLogArguments);
        XxlJobLogger.log(appendLog);
    }
}

