/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.handler.impl;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.job.core.util.ScriptUtil;

public class ScriptJobHandler
extends IJobHandler {
    private int jobId;
    private long glueUpdatetime;
    private String gluesource;
    private GlueTypeEnum glueType;

    public ScriptJobHandler(int jobId, long glueUpdatetime, String gluesource, GlueTypeEnum glueType) {
        this.jobId = jobId;
        this.glueUpdatetime = glueUpdatetime;
        this.gluesource = gluesource;
        this.glueType = glueType;
    }

    public long getGlueUpdatetime() {
        return this.glueUpdatetime;
    }

    @Override
    public ReturnT<String> execute(String ... params) throws Exception {
        String cmd = "bash";
        String scriptFileName = null;
        if (GlueTypeEnum.GLUE_SHELL == this.glueType) {
            cmd = "bash";
            scriptFileName = XxlJobFileAppender.logPath.concat("gluesource/").concat(String.valueOf(this.jobId)).concat("_").concat(String.valueOf(this.glueUpdatetime)).concat(".sh");
        } else if (GlueTypeEnum.GLUE_PYTHON == this.glueType) {
            cmd = "python";
            scriptFileName = XxlJobFileAppender.logPath.concat("gluesource/").concat(String.valueOf(this.jobId)).concat("_").concat(String.valueOf(this.glueUpdatetime)).concat(".py");
        }
        ScriptUtil.markScriptFile(scriptFileName, this.gluesource);
        String logFileName = XxlJobFileAppender.logPath.concat((String)XxlJobFileAppender.contextHolder.get());
        XxlJobLogger.log("----------- script file:" + scriptFileName + " -----------");
        int exitValue = ScriptUtil.execToFile(cmd, scriptFileName, logFileName, params);
        ReturnT result = exitValue == 0 ? ReturnT.SUCCESS : new ReturnT(500, "script exit value(" + exitValue + ") is failed");
        return result;
    }
}

