/*
 * Decompiled with CFR 0.152.
 */
package com.webank.blockchain.hsm.crypto.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class NativeUtils {
    public static String getResourceTailByOs(String osName) {
        if (osName == null || osName.isEmpty()) {
            throw new IllegalArgumentException("osName cannot be null or empty");
        }
        if ((osName = osName.toLowerCase()).contains("linux")) {
            String osArch = System.getProperty("os.arch").toLowerCase();
            if ("aarch64".equals(osArch)) {
                return "_arm.so";
            }
            return "_x86.so";
        }
        throw new IllegalArgumentException("does not support os :" + osName);
    }

    public static void loadLibrary(String resourcePath) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        NativeUtils.loadLibrary(resourcePath, classLoader);
    }

    public static boolean loadLibraryFromLibraryPath(String libraryDirPath, String resourcePath) throws IOException {
        String fileName = NativeUtils.deduceFileName(resourcePath);
        File libraryFilePath = new File(new File(libraryDirPath), fileName);
        if (!libraryFilePath.exists() || !new File(libraryDirPath).exists()) {
            return false;
        }
        System.load(libraryFilePath.getAbsolutePath());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String resourcePath, ClassLoader classLoader) throws IOException {
        String libraryDirPath = System.getProperty("java.library.ffipath");
        if (libraryDirPath != null && !libraryDirPath.isEmpty() && NativeUtils.loadLibraryFromLibraryPath(libraryDirPath, resourcePath)) {
            return;
        }
        File tmpDir = new File(System.getProperty("user.home"));
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            throw new IOException("user dir unavailable");
        }
        File ffiDir = new File(new File(tmpDir, ".fisco"), "nativeutils");
        if (!(ffiDir.exists() && ffiDir.isDirectory() || ffiDir.mkdirs())) {
            throw new IOException("failed to create temp folder");
        }
        String fileName = NativeUtils.deduceFileName(resourcePath);
        File tmpFile = new File(ffiDir, fileName);
        File lockFile = new File(ffiDir, "native.lock");
        lockFile.deleteOnExit();
        FileLock lock = null;
        try (FileChannel c = new FileOutputStream(lockFile, true).getChannel();){
            lock = c.lock();
            try (InputStream input = classLoader.getResourceAsStream(resourcePath);){
                if (input == null) {
                    throw new IOException("Resource not found:" + resourcePath + " for classloader " + classLoader.toString());
                }
                Files.copy(input, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
            System.load(tmpFile.getAbsolutePath());
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                    lockFile.delete();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String deduceFileName(String path) {
        String[] parts = path.split("/");
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        throw new IllegalArgumentException("invalid path " + path);
    }

    private NativeUtils() {
    }
}

