/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.utils;

import com.selectdb.flink.exception.SelectdbRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffAndRetryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BackoffAndRetryUtils.class);
    private static final int[] backoffSec = new int[]{0, 1, 2, 4};

    public static Object backoffAndRetry(LoadOperation operation, backoffFunction runnable) throws Exception {
        String error = "";
        for (int index = 0; index < backoffSec.length; ++index) {
            if (index != 0) {
                int second = backoffSec[index];
                Thread.sleep((long)second * 1000L);
                LOG.info("Retry operation {} {} times", (Object)operation, (Object)index);
            }
            try {
                return runnable.apply();
            }
            catch (Exception e) {
                error = e.getMessage();
                LOG.error("Request failed, caught an exception for operation {} with message:{}", (Object)operation, (Object)e.getMessage());
                continue;
            }
        }
        String errMsg = String.format("Retry exceeded the max retry limit, operation = %s, error message is %s", new Object[]{operation, error});
        LOG.error(errMsg);
        throw new SelectdbRuntimeException(errMsg);
    }

    public static enum LoadOperation {
        GET_INTERNAL_STAGE_ADDRESS,
        UPLOAD_FILE;

    }

    public static interface backoffFunction {
        public Object apply() throws Exception;
    }
}

