/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.cfg;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.util.Preconditions;

public class SelectdbExecutionOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final int DEFAULT_BUFFER_SIZE = 0x500000;
    private static final int DEFAULT_BUFFER_COUNT = 10000;
    private final int maxRetries;
    private final int bufferSize;
    private final int bufferCount;
    private final String labelPrefix;
    private final Properties loadProps;
    private final Boolean enableDelete;
    private final int flushQueueSize;
    private final Boolean ignoreUpdateBefore;

    public SelectdbExecutionOptions(int maxRetries, int bufferSize, int bufferCount, Properties loadProps, Boolean enableDelete, int flushQueueSize, Boolean ignoreUpdateBefore) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0);
        this.maxRetries = maxRetries;
        this.bufferSize = bufferSize;
        this.bufferCount = bufferCount;
        this.loadProps = loadProps;
        this.enableDelete = enableDelete;
        this.labelPrefix = UUID.randomUUID().toString();
        this.flushQueueSize = flushQueueSize;
        this.ignoreUpdateBefore = ignoreUpdateBefore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SelectdbExecutionOptions defaults() {
        Properties properties = new Properties();
        properties.setProperty("file.type", "json");
        properties.setProperty("file.strip_outer_array", "false");
        return new Builder().setLoadProps(properties).build();
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public Properties getLoadProps() {
        return this.loadProps;
    }

    public Boolean getDeletable() {
        return this.enableDelete;
    }

    public int getFlushQueueSize() {
        return this.flushQueueSize;
    }

    public Boolean getIgnoreUpdateBefore() {
        return this.ignoreUpdateBefore;
    }

    public static class Builder {
        private int maxRetries = 3;
        private int bufferSize = 0x500000;
        private int bufferCount = 10000;
        private Properties loadProps = new Properties();
        private boolean enableDelete = false;
        private int flushQueueSize = 1;
        private boolean ignoreUpdateBefore = true;

        public Builder setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setBufferCount(int bufferCount) {
            this.bufferCount = bufferCount;
            return this;
        }

        public Builder setLoadProps(Properties loadProps) {
            this.loadProps = loadProps;
            return this;
        }

        public Builder setDeletable(Boolean enableDelete) {
            this.enableDelete = enableDelete;
            return this;
        }

        public Builder setFlushQueueSize(int flushQueueSize) {
            this.flushQueueSize = flushQueueSize;
            return this;
        }

        public Builder setIgnoreUpdateBefore(Boolean ignoreUpdateBefore) {
            this.ignoreUpdateBefore = ignoreUpdateBefore;
            return this;
        }

        public SelectdbExecutionOptions build() {
            return new SelectdbExecutionOptions(this.maxRetries, this.bufferSize, this.bufferCount, this.loadProps, this.enableDelete, this.flushQueueSize, this.ignoreUpdateBefore);
        }
    }
}

