/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.flink.cfg;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class SelectdbConnectionOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String driverName = "com.mysql.jdbc.Driver";
    protected final String cjDriverName = "com.mysql.cj.jdbc.Driver";
    protected final String loadUrl;
    protected final String jdbcUrl;
    protected final String clusterName;
    protected final String username;
    protected final String password;

    public SelectdbConnectionOptions(String loadUrl, String jdbcUrl, String clusterName, String username, String password) {
        this.loadUrl = (String)Preconditions.checkNotNull((Object)loadUrl, (String)"loadUrl  is empty");
        this.jdbcUrl = (String)Preconditions.checkNotNull((Object)jdbcUrl, (String)"jdbcUrl  is empty");
        this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (String)"clusterName is empty");
        this.username = username;
        this.password = password;
    }

    public String getLoadUrl() {
        return this.loadUrl;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCjDriverName() {
        return "com.mysql.cj.jdbc.Driver";
    }

    public String getDriverName() {
        return "com.mysql.jdbc.Driver";
    }

    public static class SelectdbConnectionOptionsBuilder {
        private String loadUrl;
        private String jdbcUrl;
        private String clusterName;
        private String username;
        private String password;

        public SelectdbConnectionOptionsBuilder withLoadUrl(String loadUrl) {
            this.loadUrl = loadUrl;
            return this;
        }

        public SelectdbConnectionOptionsBuilder withJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public SelectdbConnectionOptionsBuilder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public SelectdbConnectionOptionsBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public SelectdbConnectionOptionsBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public SelectdbConnectionOptions build() {
            return new SelectdbConnectionOptions(this.loadUrl, this.jdbcUrl, this.clusterName, this.username, this.password);
        }
    }
}

