/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.util.List;

public class CardCodeApi {
    private static String getCodeUrl = "https://api.weixin.qq.com/card/code/get?access_token=";
    private static String consumeCode = "https://api.weixin.qq.com/card/code/consume?access_token=";
    private static String decryptCode = "https://api.weixin.qq.com/card/code/decrypt?access_token=";
    private static String setDeposit = "http://api.weixin.qq.com/card/code/deposit?access_token=";
    private static String getDepositCount = "http://api.weixin.qq.com/card/code/getdepositcount?access_token=";
    private static String checkCode = "http://api.weixin.qq.com/card/code/checkcode?access_token=";
    private static String update = "https://api.weixin.qq.com/card/code/update?access_token=";
    private static String mark = "https://api.weixin.qq.com/card/code/mark?access_token=";

    public static ApiResult get(String code, String cardId, boolean checkConsume) {
        Kv data = Kv.by((Object)"code", (Object)code);
        if (StrKit.notBlank((String)cardId)) {
            data.set((Object)"card_id", (Object)cardId);
        }
        data.set((Object)"check_consume", (Object)checkConsume);
        String jsonResult = HttpUtils.post(getCodeUrl + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult consume(String code) {
        return CardCodeApi.consume(code, null);
    }

    public static ApiResult consume(String code, String cardId) {
        Kv data = Kv.by((Object)"code", (Object)code);
        if (StrKit.notBlank((String)cardId)) {
            data.set((Object)"card_id", (Object)cardId);
        }
        String jsonResult = HttpUtils.post(consumeCode + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult consumeOnline(String code, String openid) {
        Kv data = Kv.by((Object)"code", (Object)code).set((Object)"openid", (Object)openid);
        String jsonResult = HttpUtils.post(consumeCode + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult decrypt(String encryptCode) {
        Kv data = Kv.by((Object)"encrypt_code", (Object)encryptCode);
        String jsonResult = HttpUtils.post(decryptCode + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult setDeposit(String cardId, List<String> codeList) {
        Kv data = Kv.by((Object)"card_id", (Object)cardId).set((Object)"code", codeList);
        String jsonResult = HttpUtils.post(setDeposit + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getDepositCount(String cardId) {
        Kv data = Kv.by((Object)"card_id", (Object)cardId);
        String jsonResult = HttpUtils.post(getDepositCount + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult checkCode(String cardId, List<String> codeList) {
        Kv data = Kv.by((Object)"card_id", (Object)cardId).set((Object)"code", codeList);
        String jsonResult = HttpUtils.post(checkCode + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult update(String code, String newCode) {
        return CardCodeApi.update(null, code, newCode);
    }

    public static ApiResult update(String cardId, String code, String newCode) {
        Kv data = Kv.by((Object)"code", (Object)code).set((Object)"new_code", (Object)newCode);
        if (StrKit.notBlank((String)cardId)) {
            data.set((Object)"card_id", (Object)cardId);
        }
        String jsonResult = HttpUtils.post(update + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult markCode(String code, String cardId, String openid, boolean isMark) {
        Kv data = Kv.by((Object)"code", (Object)code).set((Object)"card_id", (Object)cardId).set((Object)"openid", (Object)openid).set((Object)"is_mark", (Object)isMark);
        String jsonResult = HttpUtils.post(mark + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }
}

