/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.zookeeper.curator;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.registry.NodeRegistryUtils;
import com.github.ltsopensource.zookeeper.ChildListener;
import com.github.ltsopensource.zookeeper.DataListener;
import com.github.ltsopensource.zookeeper.lts.ZkException;
import com.github.ltsopensource.zookeeper.serializer.SerializableSerializer;
import com.github.ltsopensource.zookeeper.serializer.ZkSerializer;
import com.github.ltsopensource.zookeeper.support.AbstractZkClient;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class CuratorZkClient
extends AbstractZkClient<PathChildrenListener, NodeListener> {
    private final CuratorFramework client;
    private final ZkSerializer zkSerializer;

    public CuratorZkClient(Config config) {
        String registryAddress = NodeRegistryUtils.getRealRegistryAddress(config.getRegistryAddress());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(registryAddress).retryPolicy((RetryPolicy)new RetryNTimes(Integer.MAX_VALUE, 1000)).connectionTimeoutMs(5000);
        this.client = builder.build();
        this.client.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState state) {
                if (state == ConnectionState.LOST) {
                    CuratorZkClient.this.stateChanged(0);
                } else if (state == ConnectionState.CONNECTED) {
                    CuratorZkClient.this.stateChanged(1);
                } else if (state == ConnectionState.RECONNECTED) {
                    CuratorZkClient.this.stateChanged(2);
                } else if (state == ConnectionState.SUSPENDED) {
                    CuratorZkClient.this.stateChanged(0);
                }
            }
        });
        this.zkSerializer = new SerializableSerializer();
        this.client.start();
    }

    @Override
    protected String createPersistent(String path, boolean sequential) {
        try {
            if (sequential) {
                return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(path);
            }
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT)).forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            return path;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected String createPersistent(String path, Object data, boolean sequential) {
        try {
            if (sequential) {
                byte[] zkDataBytes = data instanceof Serializable ? this.zkSerializer.serialize(data) : (byte[])data;
                return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(path, zkDataBytes);
            }
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT)).forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            return path;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected String createEphemeral(String path, boolean sequential) {
        try {
            if (sequential) {
                return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path);
            }
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            return path;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected String createEphemeral(String path, Object data, boolean sequential) {
        try {
            if (sequential) {
                byte[] zkDataBytes = data instanceof Serializable ? this.zkSerializer.serialize(data) : (byte[])data;
                return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path, zkDataBytes);
            }
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            return path;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected PathChildrenListener createTargetChildListener(String path, ChildListener listener) {
        return new PathChildrenListener(path, listener);
    }

    @Override
    protected List<String> addTargetChildListener(String path, PathChildrenListener listener) {
        try {
            listener.startListener();
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void removeTargetChildListener(String path, PathChildrenListener listener) {
        listener.stopListener();
    }

    @Override
    protected void addTargetDataListener(String path, NodeListener listener) {
        listener.startListener();
    }

    @Override
    protected NodeListener createTargetDataListener(String path, DataListener listener) {
        return new NodeListener(path, listener);
    }

    @Override
    protected void removeTargetDataListener(String path, NodeListener listener) {
        listener.stopListener();
    }

    @Override
    public boolean delete(String path) {
        try {
            this.client.delete().forPath(path);
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean exists(String path) {
        try {
            return this.client.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T getData(String path) {
        try {
            return (T)this.zkSerializer.deserialize((byte[])this.client.getData().forPath(path));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void setData(String path, Object data) {
        byte[] zkDataBytes = data instanceof Serializable ? this.zkSerializer.serialize(data) : (byte[])data;
        try {
            this.client.setData().forPath(path, zkDataBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    @Override
    protected void doClose() {
        this.client.close();
    }

    public class NodeListener {
        private NodeCache nodeCache;
        private NodeCacheListener nodeCacheListener;
        private AtomicBoolean start = new AtomicBoolean(false);

        public NodeListener(String path, final DataListener listener) {
            this.nodeCache = new NodeCache(CuratorZkClient.this.client, path, false);
            this.nodeCacheListener = new NodeCacheListener(){

                public void nodeChanged() throws Exception {
                    String path = NodeListener.this.nodeCache.getCurrentData().getPath();
                    byte[] data = NodeListener.this.nodeCache.getCurrentData().getData();
                    if (data == null) {
                        listener.dataDeleted(path);
                    } else {
                        listener.dataChange(path, data);
                    }
                }
            };
        }

        public void startListener() {
            try {
                if (this.start.compareAndSet(false, true)) {
                    this.nodeCache.start(true);
                    this.nodeCache.getListenable().addListener((Object)this.nodeCacheListener);
                }
            }
            catch (Exception e) {
                throw new ZkException(e);
            }
        }

        public void stopListener() {
            try {
                if (this.start.compareAndSet(true, false)) {
                    this.nodeCache.getListenable().removeListener((Object)this.nodeCacheListener);
                    this.nodeCache.close();
                }
            }
            catch (IOException e) {
                throw new ZkException(e);
            }
        }
    }

    public class PathChildrenListener {
        private PathChildrenCache childrenCache;
        private PathChildrenCacheListener childrenCacheListener;
        private AtomicBoolean start = new AtomicBoolean(false);

        public PathChildrenListener(String path, final ChildListener listener) {
            this.childrenCache = new PathChildrenCache(CuratorZkClient.this.client, path, true);
            this.childrenCacheListener = new PathChildrenCacheListener(){

                public void childEvent(CuratorFramework c, PathChildrenCacheEvent event) throws Exception {
                    switch (event.getType()) {
                        case CHILD_ADDED: 
                        case CHILD_REMOVED: 
                        case CHILD_UPDATED: {
                            String childPath = event.getData().getPath();
                            String parentPath = childPath.substring(0, childPath.lastIndexOf("/"));
                            List children = (List)CuratorZkClient.this.client.getChildren().forPath(parentPath);
                            listener.childChanged(parentPath, children);
                        }
                    }
                }
            };
        }

        public void startListener() {
            try {
                if (this.start.compareAndSet(false, true)) {
                    this.childrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
                    this.childrenCache.getListenable().addListener((Object)this.childrenCacheListener);
                }
            }
            catch (Exception e) {
                throw new ZkException(e);
            }
        }

        public void stopListener() {
            try {
                if (this.start.compareAndSet(true, false)) {
                    this.childrenCache.getListenable().removeListener((Object)this.childrenCacheListener);
                    this.childrenCache.clear();
                    this.childrenCache.close();
                }
            }
            catch (IOException e) {
                throw new ZkException(e);
            }
        }
    }
}

