/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.monitor;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.domain.monitor.TaskTrackerMData;
import com.github.ltsopensource.core.monitor.AbstractMStatReporter;
import java.util.concurrent.atomic.AtomicLong;

public class TaskTrackerMStatReporter
extends AbstractMStatReporter {
    private AtomicLong exeSuccessNum = new AtomicLong(0L);
    private AtomicLong exeFailedNum = new AtomicLong(0L);
    private AtomicLong exeLaterNum = new AtomicLong(0L);
    private AtomicLong exeExceptionNum = new AtomicLong(0L);
    private AtomicLong totalRunningTime = new AtomicLong(0L);

    public TaskTrackerMStatReporter(AppContext appContext) {
        super(appContext);
    }

    public void incSuccessNum() {
        this.exeSuccessNum.incrementAndGet();
    }

    public void incFailedNum() {
        this.exeFailedNum.incrementAndGet();
    }

    public void incExeLaterNum() {
        this.exeLaterNum.incrementAndGet();
    }

    public void incExeExceptionNum() {
        this.exeExceptionNum.incrementAndGet();
    }

    public void addRunningTime(Long time) {
        this.totalRunningTime.addAndGet(time);
    }

    @Override
    protected MData collectMData() {
        TaskTrackerMData mData = new TaskTrackerMData();
        mData.setExeSuccessNum(this.exeSuccessNum.getAndSet(0L));
        mData.setExeFailedNum(this.exeFailedNum.getAndSet(0L));
        mData.setExeLaterNum(this.exeLaterNum.getAndSet(0L));
        mData.setExeExceptionNum(this.exeExceptionNum.getAndSet(0L));
        mData.setTotalRunningTime(this.totalRunningTime.getAndSet(0L));
        return mData;
    }

    @Override
    protected NodeType getNodeType() {
        return NodeType.TASK_TRACKER;
    }
}

