/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.cmd;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.cmd.HttpCmdRequest;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;

public class JobTerminateCmd
implements HttpCmdProc {
    private TaskTrackerAppContext appContext;

    public JobTerminateCmd(TaskTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public String nodeIdentity() {
        return this.appContext.getConfig().getIdentity();
    }

    @Override
    public String getCommand() {
        return "job_terminate_cmd";
    }

    @Override
    public HttpCmdResponse execute(HttpCmdRequest request) throws Exception {
        String jobId = request.getParam("jobId");
        if (StringUtils.isEmpty(jobId)) {
            return HttpCmdResponse.newResponse(false, "jobId can't be empty");
        }
        if (!this.appContext.getRunnerPool().getRunningJobManager().running(jobId)) {
            return HttpCmdResponse.newResponse(false, "jobId dose not running in this TaskTracker now");
        }
        this.appContext.getRunnerPool().getRunningJobManager().terminateJob(jobId);
        return HttpCmdResponse.newResponse(true, "Execute terminate Command success");
    }
}

