/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.netty;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.remoting.codec.Codec;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.netty.NettyChannel;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.ByteBuffer;

public class NettyCodecFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyCodecFactory.class);
    private Codec codec;
    private AppContext appContext;

    public NettyCodecFactory(AppContext appContext, Codec codec) {
        this.appContext = appContext;
        this.codec = codec;
    }

    public ChannelHandler getEncoder() {
        return new NettyEncoder();
    }

    public ChannelHandler getDecoder() {
        return new NettyDecoder();
    }

    public class NettyDecoder
    extends LengthFieldBasedFrameDecoder {
        public NettyDecoder() {
            super(NettyCodecFactory.this.appContext.getConfig().getParameter("netty.frame.length.max", 0x1000000), 0, 4, 0, 4);
        }

        public Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            try {
                ByteBuf frame = (ByteBuf)super.decode(ctx, in);
                if (frame == null) {
                    return null;
                }
                byte[] tmpBuf = new byte[frame.capacity()];
                frame.getBytes(0, tmpBuf);
                frame.release();
                ByteBuffer byteBuffer = ByteBuffer.wrap(tmpBuf);
                return NettyCodecFactory.this.codec.decode(byteBuffer);
            }
            catch (Exception e) {
                NettyChannel channel = new NettyChannel(ctx);
                LOGGER.error("decode exception, {}", RemotingHelper.parseChannelRemoteAddr(channel), e);
                RemotingHelper.closeChannel(channel);
                return null;
            }
        }
    }

    @ChannelHandler.Sharable
    public class NettyEncoder
    extends MessageToByteEncoder<RemotingCommand> {
        public void encode(ChannelHandlerContext ctx, RemotingCommand remotingCommand, ByteBuf out) throws Exception {
            if (remotingCommand == null) {
                LOGGER.error("Message is null");
                return;
            }
            try {
                ByteBuffer byteBuffer = NettyCodecFactory.this.codec.encode(remotingCommand);
                out.writeBytes(byteBuffer);
            }
            catch (Exception e) {
                NettyChannel channel = new NettyChannel(ctx);
                LOGGER.error("encode exception, addr={}, remotingCommand={}", RemotingHelper.parseChannelRemoteAddr(channel), remotingCommand.toString(), e);
                RemotingHelper.closeChannel(channel);
            }
        }
    }
}

