/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.lts;

import com.github.ltsopensource.nio.NioServer;
import com.github.ltsopensource.nio.channel.ChannelInitializer;
import com.github.ltsopensource.nio.codec.Decoder;
import com.github.ltsopensource.nio.codec.Encoder;
import com.github.ltsopensource.nio.config.NioServerConfig;
import com.github.ltsopensource.remoting.AbstractRemotingServer;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.RemotingServerConfig;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.lts.LtsCodecFactory;
import com.github.ltsopensource.remoting.lts.LtsEventHandler;
import java.net.InetSocketAddress;

public class LtsRemotingServer
extends AbstractRemotingServer {
    private NioServer server;

    public LtsRemotingServer(RemotingServerConfig remotingServerConfig, ChannelEventListener channelEventListener) {
        super(remotingServerConfig, channelEventListener);
    }

    public LtsRemotingServer(RemotingServerConfig remotingServerConfig) {
        this(remotingServerConfig, null);
    }

    @Override
    protected void serverStart() throws RemotingException {
        NioServerConfig serverConfig = new NioServerConfig();
        serverConfig.setBacklog(65536);
        serverConfig.setReuseAddress(true);
        serverConfig.setTcpNoDelay(true);
        serverConfig.setIdleTimeBoth(this.remotingServerConfig.getServerChannelMaxIdleTimeSeconds());
        serverConfig.setIdleTimeWrite(this.remotingServerConfig.getWriterIdleTimeSeconds());
        serverConfig.setIdleTimeRead(this.remotingServerConfig.getReaderIdleTimeSeconds());
        final LtsCodecFactory codecFactory = new LtsCodecFactory(this.getCodec());
        this.server = new NioServer(serverConfig, new LtsEventHandler(this, "SERVER"), new ChannelInitializer(){

            @Override
            protected Decoder getDecoder() {
                return codecFactory.getDecoder();
            }

            @Override
            protected Encoder getEncoder() {
                return codecFactory.getEncoder();
            }
        });
        this.server.bind(new InetSocketAddress(this.remotingServerConfig.getListenPort()));
    }

    @Override
    protected void serverShutdown() throws RemotingException {
        this.server.shutdownGracefully();
    }
}

