/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.common;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;

public abstract class ServiceThread
implements Runnable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final long JoinTime = 90000L;
    protected final Thread thread = new Thread((Runnable)this, this.getServiceName());
    protected volatile boolean hasNotified = false;
    protected volatile boolean stopped = false;

    public abstract String getServiceName();

    public void start() {
        this.thread.start();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void stop() {
        this.stop(false);
    }

    public void makeStop() {
        this.stopped = true;
        this.LOGGER.info("makestop thread " + this.getServiceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean interrupt) {
        this.stopped = true;
        this.LOGGER.info("stop thread " + this.getServiceName() + " interrupt " + interrupt);
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
        if (interrupt) {
            this.thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean interrupt) {
        this.stopped = true;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("shutdown thread " + this.getServiceName() + " interrupt " + interrupt);
        }
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
        try {
            if (interrupt) {
                this.thread.interrupt();
            }
            long beginTime = System.currentTimeMillis();
            this.thread.join(this.getJointime());
            if (this.LOGGER.isDebugEnabled()) {
                long eclipseTime = System.currentTimeMillis() - beginTime;
                this.LOGGER.info("join thread " + this.getServiceName() + " eclipse time(ms) " + eclipseTime + " " + this.getJointime());
            }
        }
        catch (InterruptedException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRunning(long interval) {
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (this.hasNotified) {
                this.hasNotified = false;
                this.onWaitEnd();
                return;
            }
            try {
                this.wait(interval);
            }
            catch (InterruptedException e) {
                this.LOGGER.error(e.getMessage(), e);
            }
            finally {
                this.hasNotified = false;
                this.onWaitEnd();
            }
        }
    }

    protected void onWaitEnd() {
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public long getJointime() {
        return 90000L;
    }
}

