/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mysql;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.SchedulerJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mysql.AbstractMysqlJobQueue;
import com.github.ltsopensource.queue.mysql.support.RshHolder;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.UpdateSql;
import java.util.List;

public abstract class MysqlSchedulerJobQueue
extends AbstractMysqlJobQueue
implements SchedulerJobQueue {
    public MysqlSchedulerJobQueue(Config config) {
        super(config);
    }

    @Override
    public boolean updateLastGenerateTriggerTime(String jobId, Long lastGenerateTriggerTime) {
        return new UpdateSql(this.getSqlTemplate()).update().table(this.getTableName()).set("last_generate_trigger_time", lastGenerateTriggerTime).set("gmt_modified", SystemClock.now()).where("job_id = ? ", jobId).doUpdate() == 1;
    }

    @Override
    public List<JobPo> getNeedGenerateJobPos(Long checkTime, int topSize) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("rely_on_prev_cycle = ?", false).and("last_generate_trigger_time <= ?", checkTime).limit(0, topSize).list(RshHolder.JOB_PO_LIST_RSH);
    }

    protected abstract String getTableName();
}

