/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.processor;

import com.github.ltsopensource.nio.NioException;
import com.github.ltsopensource.nio.channel.ChannelInitializer;
import com.github.ltsopensource.nio.channel.NioChannel;
import com.github.ltsopensource.nio.channel.NioChannelImpl;
import com.github.ltsopensource.nio.config.NioClientConfig;
import com.github.ltsopensource.nio.handler.Futures;
import com.github.ltsopensource.nio.handler.NioHandler;
import com.github.ltsopensource.nio.loop.NioSelectorLoop;
import com.github.ltsopensource.nio.processor.AbstractNioProcessor;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class NioClientProcessor
extends AbstractNioProcessor {
    private NioClientConfig clientConfig;
    private NioChannelImpl channel;

    public NioClientProcessor(NioClientConfig clientConfig, NioHandler eventHandler, ChannelInitializer channelInitializer) {
        super(eventHandler, channelInitializer);
        this.clientConfig = clientConfig;
    }

    @Override
    protected NioChannel doAccept(NioSelectorLoop selectorLoop) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected NioChannel doConnect(SocketAddress remoteAddress, NioSelectorLoop selectorLoop, Futures.ConnectFuture connectFuture) {
        SocketChannel socketChannel = NioClientProcessor.newSocket();
        try {
            socketChannel.socket().setSoTimeout(this.clientConfig.getConnectTimeout());
            socketChannel.configureBlocking(false);
            if (this.clientConfig.getTcpNoDelay() != null) {
                socketChannel.socket().setTcpNoDelay(this.clientConfig.getTcpNoDelay());
            }
            if (this.clientConfig.getReceiveBufferSize() != null) {
                socketChannel.socket().setReceiveBufferSize(this.clientConfig.getReceiveBufferSize());
            }
            if (this.clientConfig.getKeepAlive() != null) {
                socketChannel.socket().setKeepAlive(this.clientConfig.getKeepAlive());
            }
            if (this.clientConfig.getReuseAddress() != null) {
                socketChannel.socket().setReuseAddress(this.clientConfig.getReuseAddress());
            }
            if (this.clientConfig.getIpTos() != null) {
                socketChannel.socket().setTrafficClass(this.clientConfig.getIpTos());
            }
            if (this.clientConfig.getOobInline() != null) {
                socketChannel.socket().setOOBInline(this.clientConfig.getOobInline());
            }
            if (this.clientConfig.getSoLinger() != null) {
                socketChannel.socket().setSoLinger(true, this.clientConfig.getSoLinger());
            }
        }
        catch (IOException e) {
            throw new NioException("connect IOE", e);
        }
        this.channel = new NioChannelImpl(selectorLoop, this, socketChannel, this.eventHandler(), this.clientConfig);
        try {
            socketChannel.connect(remoteAddress);
            socketChannel.register(this.selectorLoop.selector(), 8);
        }
        catch (IOException e) {
            connectFuture.setCause(e);
            connectFuture.setSuccess(false);
            connectFuture.notifyListeners();
            this.channel = null;
            return null;
        }
        this.channelInitializer.initChannel(this.channel);
        this.idleDetector.addChannel(this.channel);
        connectFuture.setSuccess(true);
        connectFuture.setChannel(this.channel);
        connectFuture.notifyListeners();
        return this.channel;
    }

    private static SocketChannel newSocket() {
        try {
            return SocketChannel.open();
        }
        catch (IOException e) {
            throw new NioException("can't create a new socket, out of file descriptors ?", e);
        }
    }

    @Override
    public void connect(SelectionKey key) {
        try {
            this.channel.socketChannel().finishConnect();
            key.attach(this.channel);
        }
        catch (IOException e) {
            this.eventHandler().exceptionCaught(this.channel, e);
            key.cancel();
            return;
        }
        key.interestOps(1);
    }
}

