/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.monitor.cmd;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.monitor.JobClientMData;
import com.github.ltsopensource.core.domain.monitor.JobTrackerMData;
import com.github.ltsopensource.core.domain.monitor.JvmMData;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.domain.monitor.MNode;
import com.github.ltsopensource.core.domain.monitor.TaskTrackerMData;
import com.github.ltsopensource.core.exception.LtsRuntimeException;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.core.support.bean.BeanCopier;
import com.github.ltsopensource.core.support.bean.BeanCopierFactory;
import com.github.ltsopensource.monitor.MonitorAppContext;
import com.github.ltsopensource.monitor.access.domain.JVMGCDataPo;
import com.github.ltsopensource.monitor.access.domain.JVMMemoryDataPo;
import com.github.ltsopensource.monitor.access.domain.JVMThreadDataPo;
import com.github.ltsopensource.monitor.access.domain.JobClientMDataPo;
import com.github.ltsopensource.monitor.access.domain.JobTrackerMDataPo;
import com.github.ltsopensource.monitor.access.domain.MDataPo;
import com.github.ltsopensource.monitor.access.domain.TaskTrackerMDataPo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MDataSrv {
    private MonitorAppContext appContext;
    private static final BeanCopier<JobClientMData, JobClientMDataPo> jobClientMDataBeanCopier = BeanCopierFactory.createCopier(JobClientMData.class, JobClientMDataPo.class);
    private static final BeanCopier<JobTrackerMData, JobTrackerMDataPo> jobTrackerMDataBeanCopier = BeanCopierFactory.createCopier(JobTrackerMData.class, JobTrackerMDataPo.class);
    private static final BeanCopier<TaskTrackerMData, TaskTrackerMDataPo> taskTrackerMDataBeanCopier = BeanCopierFactory.createCopier(TaskTrackerMData.class, TaskTrackerMDataPo.class);
    private static final Map<String, Method> CACHED_METHOD_MAP = new ConcurrentHashMap<String, Method>();

    public MDataSrv(MonitorAppContext appContext) {
        this.appContext = appContext;
    }

    public void addMDatas(MNode mNode, List<MData> mDatas) {
        if (CollectionUtils.isEmpty(mDatas)) {
            return;
        }
        switch (mNode.getNodeType()) {
            case JOB_CLIENT: {
                this.addJobClientMData(mNode, mDatas);
                break;
            }
            case JOB_TRACKER: {
                this.addJobTrackerMData(mNode, mDatas);
                break;
            }
            case TASK_TRACKER: {
                this.addTaskTrackerMData(mNode, mDatas);
                break;
            }
            default: {
                throw new LtsRuntimeException("Unsupport nodeType:" + (Object)((Object)mNode.getNodeType()));
            }
        }
    }

    private void addJobClientMData(MNode mNode, List<MData> mDatas) {
        ArrayList<JobClientMDataPo> pos = new ArrayList<JobClientMDataPo>(mDatas.size());
        for (MData mData : mDatas) {
            JobClientMDataPo po = new JobClientMDataPo();
            jobClientMDataBeanCopier.copyProps((JobClientMData)mData, po);
            po.setNodeType(mNode.getNodeType());
            po.setIdentity(mNode.getIdentity());
            po.setNodeGroup(mNode.getNodeGroup());
            po.setGmtCreated(SystemClock.now());
            pos.add(po);
        }
        this.appContext.getJobClientMAccess().insert(pos);
        this.addJvmMData(mNode, mDatas);
    }

    private void addJobTrackerMData(MNode mNode, List<MData> mDatas) {
        ArrayList<JobTrackerMDataPo> pos = new ArrayList<JobTrackerMDataPo>(mDatas.size());
        for (MData mData : mDatas) {
            JobTrackerMDataPo po = new JobTrackerMDataPo();
            jobTrackerMDataBeanCopier.copyProps((JobTrackerMData)mData, po);
            po.setNodeType(mNode.getNodeType());
            po.setIdentity(mNode.getIdentity());
            po.setNodeGroup(mNode.getNodeGroup());
            po.setGmtCreated(SystemClock.now());
            pos.add(po);
        }
        this.appContext.getJobTrackerMAccess().insert(pos);
        this.addJvmMData(mNode, mDatas);
    }

    private void addTaskTrackerMData(MNode mNode, List<MData> mDatas) {
        ArrayList<TaskTrackerMDataPo> pos = new ArrayList<TaskTrackerMDataPo>(mDatas.size());
        for (MData mData : mDatas) {
            TaskTrackerMDataPo po = new TaskTrackerMDataPo();
            taskTrackerMDataBeanCopier.copyProps((TaskTrackerMData)mData, po);
            po.setNodeType(mNode.getNodeType());
            po.setIdentity(mNode.getIdentity());
            po.setNodeGroup(mNode.getNodeGroup());
            po.setGmtCreated(SystemClock.now());
            pos.add(po);
        }
        this.appContext.getTaskTrackerMAccess().insert(pos);
        this.addJvmMData(mNode, mDatas);
    }

    public void addJvmMData(MNode mNode, List<MData> mDatas) {
        int size = mDatas.size();
        ArrayList<JVMGCDataPo> jvmGCDataPos = new ArrayList<JVMGCDataPo>(size);
        ArrayList<JVMMemoryDataPo> jvmMemoryDataPos = new ArrayList<JVMMemoryDataPo>(size);
        ArrayList<JVMThreadDataPo> jvmThreadDataPos = new ArrayList<JVMThreadDataPo>(size);
        for (MData mData : mDatas) {
            JvmMData JVMMData = mData.getJvmMData();
            Long timestamp = mData.getTimestamp();
            JVMGCDataPo jvmgcDataPo = this.getDataPo(JVMMData.getGcMap(), JVMGCDataPo.class, mNode, timestamp);
            jvmGCDataPos.add(jvmgcDataPo);
            JVMMemoryDataPo jvmMemoryDataPo = this.getDataPo(JVMMData.getMemoryMap(), JVMMemoryDataPo.class, mNode, timestamp);
            jvmMemoryDataPos.add(jvmMemoryDataPo);
            JVMThreadDataPo jvmThreadDataPo = this.getDataPo(JVMMData.getThreadMap(), JVMThreadDataPo.class, mNode, timestamp);
            jvmThreadDataPos.add(jvmThreadDataPo);
        }
        this.appContext.getJvmGCAccess().insert(jvmGCDataPos);
        this.appContext.getJvmMemoryAccess().insert(jvmMemoryDataPos);
        this.appContext.getJvmThreadAccess().insert(jvmThreadDataPos);
    }

    private static void cacheMethod(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().startsWith("set")) continue;
            CACHED_METHOD_MAP.put(clazz.getSimpleName() + "_" + method.getName().substring(3), method);
        }
    }

    private <T extends MDataPo> T getDataPo(Map<String, Object> dataMap, Class<T> clazz, MNode mNode, Long timestamp) {
        try {
            MDataPo data = (MDataPo)clazz.newInstance();
            if (CollectionUtils.isNotEmpty(dataMap)) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    Method method = CACHED_METHOD_MAP.get(clazz.getSimpleName() + "_" + entry.getKey());
                    if (method == null) continue;
                    String string = String.valueOf(entry.getValue());
                    Object value = entry.getValue();
                    Class<?> parameterType = method.getParameterTypes()[0];
                    if (parameterType == Long.class || parameterType == Long.TYPE) {
                        value = Long.valueOf(string);
                    } else if (parameterType == Integer.class || parameterType == Integer.TYPE) {
                        value = Integer.valueOf(string);
                    } else if (parameterType == Float.class || parameterType == Float.TYPE) {
                        value = Float.valueOf(string);
                    } else if (parameterType == Double.class || parameterType == Double.TYPE) {
                        value = Double.valueOf(string);
                    } else if (parameterType == Short.class || parameterType == Short.TYPE) {
                        value = Short.valueOf(string);
                    } else if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
                        value = Boolean.valueOf(string);
                    } else if (parameterType == String.class) {
                        value = string;
                    }
                    method.invoke((Object)data, value);
                }
            }
            data.setNodeType(mNode.getNodeType());
            data.setNodeGroup(mNode.getNodeGroup());
            data.setIdentity(mNode.getIdentity());
            data.setGmtCreated(SystemClock.now());
            data.setTimestamp(timestamp);
            return (T)data;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        MDataSrv.cacheMethod(JVMGCDataPo.class);
        MDataSrv.cacheMethod(JVMMemoryDataPo.class);
        MDataSrv.cacheMethod(JVMThreadDataPo.class);
    }
}

