/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.monitor.access.mysql;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.monitor.access.domain.JVMThreadDataPo;
import com.github.ltsopensource.monitor.access.face.JVMThreadAccess;
import com.github.ltsopensource.monitor.access.mysql.MysqlAbstractJdbcAccess;
import com.github.ltsopensource.store.jdbc.builder.InsertSql;
import java.util.List;

public class MysqlJVMThreadAccess
extends MysqlAbstractJdbcAccess
implements JVMThreadAccess {
    public MysqlJVMThreadAccess(Config config) {
        super(config);
    }

    @Override
    protected String getTableName() {
        return "lts_admin_jvm_thread";
    }

    @Override
    public void insert(List<JVMThreadDataPo> jvmThreadDataPos) {
        if (CollectionUtils.isEmpty(jvmThreadDataPos)) {
            return;
        }
        InsertSql insertSql = new InsertSql(this.getSqlTemplate()).insert(this.getTableName()).columns("gmt_created", "identity", "timestamp", "node_type", "node_group", "daemon_thread_count", "thread_count", "total_started_thread_count", "dead_locked_thread_count", "process_cpu_time_rate");
        for (JVMThreadDataPo po : jvmThreadDataPos) {
            insertSql.values(po.getGmtCreated(), po.getIdentity(), po.getTimestamp(), po.getNodeType().name(), po.getNodeGroup(), po.getDaemonThreadCount(), po.getThreadCount(), po.getTotalStartedThreadCount(), po.getDeadLockedThreadCount(), po.getProcessCpuTimeRate());
        }
        insertSql.doBatchInsert();
    }
}

