/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.replay;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.kv.Cursor;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.DBException;
import com.github.ltsopensource.kv.DBImpl;
import com.github.ltsopensource.kv.Operation;
import com.github.ltsopensource.kv.cache.DataCache;
import com.github.ltsopensource.kv.data.DataAppendResult;
import com.github.ltsopensource.kv.data.DataBlockEngine;
import com.github.ltsopensource.kv.index.Index;
import com.github.ltsopensource.kv.index.IndexItem;
import com.github.ltsopensource.kv.txlog.StoreTxLogCursorEntry;
import com.github.ltsopensource.kv.txlog.StoreTxLogEngine;
import com.github.ltsopensource.kv.txlog.StoreTxLogEntry;
import com.github.ltsopensource.kv.txlog.StoreTxLogPosition;

public class TxLogReplay<K, V> {
    private static final Logger LOGGER = DB.LOGGER;
    private StoreTxLogEngine<K, V> storeTxLogEngine;
    private DataBlockEngine<K, V> dataBlockEngine;
    private Index<K, V> index;
    private DataCache<K, V> dataCache;

    public TxLogReplay(StoreTxLogEngine<K, V> storeTxLogEngine, DataBlockEngine<K, V> dataBlockEngine, Index<K, V> index, DataCache<K, V> dataCache) {
        this.storeTxLogEngine = storeTxLogEngine;
        this.dataBlockEngine = dataBlockEngine;
        this.index = index;
        this.dataCache = dataCache;
    }

    public void replay(StoreTxLogPosition startPosition) {
        LOGGER.info("start to replay txLog ...");
        Cursor<StoreTxLogCursorEntry<K, V>> cursor = this.storeTxLogEngine.cursor(startPosition);
        int count = 0;
        long startTime = SystemClock.now();
        while (cursor.hasNext()) {
            StoreTxLogCursorEntry<K, V> storeTxLogCursorEntry = cursor.next();
            StoreTxLogEntry<K, V> storeTxLogEntry = storeTxLogCursorEntry.getStoreTxLogEntry();
            Operation op = storeTxLogEntry.getOp();
            StoreTxLogPosition position = storeTxLogCursorEntry.getPosition();
            K key = storeTxLogEntry.getKey();
            V value = storeTxLogEntry.getValue();
            if (op == Operation.PUT) {
                DataAppendResult dataAppendResult = this.dataBlockEngine.append(position, key, value);
                this.index.putIndexItem(position, key, DBImpl.convertToIndex(key, dataAppendResult));
            } else if (op == Operation.REMOVE) {
                IndexItem<K> indexItem = this.index.removeIndexItem(position, key);
                if (indexItem != null) {
                    this.dataBlockEngine.remove(position, indexItem);
                }
            } else {
                throw new DBException("error op=" + (Object)((Object)op));
            }
            ++count;
        }
        LOGGER.info("replay txLog complete, txLog size:" + count + ", cost mills:" + (SystemClock.now() - startTime));
    }
}

