/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.data;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.io.UnsafeByteArrayInputStream;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.kv.CapacityNotEnoughException;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.DBException;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.data.DataAppendResult;
import com.github.ltsopensource.kv.data.DataBlockFileHeader;
import com.github.ltsopensource.kv.txlog.StoreTxLogPosition;
import com.github.ltsopensource.remoting.common.ServiceThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

public class DataBlock {
    private static final Logger LOGGER = DB.LOGGER;
    private File file;
    private long fileId;
    private String fileName;
    private long fileSize;
    private FileChannel fileChannel;
    private DataBlockFileHeader fileHeader;
    private final long maxDataEntrySize = 1000L;
    private StoreConfig storeConfig;
    public static final String FILE_SUFFIX = ".ltsdata";
    private StoreTxLogPosition lastTxLogPosition;
    private FlushDataService flushDataService;
    private int totalNum;
    private int aliveNum;

    public DataBlock(String fileName, StoreConfig storeConfig) throws IOException {
        this.fileName = fileName;
        this.fileId = Long.parseLong(fileName.substring(0, fileName.lastIndexOf(".")));
        this.file = new File(storeConfig.getDataPath(), fileName);
        this.storeConfig = storeConfig;
        this.fileSize = storeConfig.getDataBlockFileSize();
        this.fileHeader = new DataBlockFileHeader();
        this.flushDataService = new FlushDataService();
        this.init();
    }

    public DataBlock(StoreConfig storeConfig) throws IOException {
        this(System.currentTimeMillis() + FILE_SUFFIX, storeConfig);
    }

    private void init() throws IOException {
        boolean success = false;
        try {
            boolean newFile;
            if (this.file.exists()) {
                if (!this.file.isFile()) {
                    throw new IOException(this.file + " is not a file");
                }
                newFile = false;
            } else {
                newFile = true;
                FileUtils.createFileIfNotExist(this.file);
            }
            this.fileChannel = FileUtils.newFileChannel(this.file, "rw");
            if (newFile) {
                this.fileHeader.write(this.fileChannel);
                this.fileHeader.setFileLength(this.fileHeader.getLength());
            } else {
                this.fileHeader.read(this.fileChannel);
                if (this.fileHeader.getFileLength() == 0L) {
                    this.fileHeader.setFileLength(this.fileHeader.getLength());
                }
            }
            this.lastTxLogPosition = new StoreTxLogPosition(this.fileHeader.getStoreTxLogRecordId());
            this.flushDataService.start();
            success = true;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("create file channel " + this.fileName + " error ", e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("map file " + this.fileName + " error ", e);
            throw e;
        }
        finally {
            if (!success && this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataAppendResult append(StoreTxLogPosition txLog, byte[] dataBytes) throws IOException {
        int length = dataBytes.length;
        DataAppendResult result = new DataAppendResult();
        DataBlock dataBlock = this;
        synchronized (dataBlock) {
            if ((long)length > 1000L) {
                throw new DBException("Value size can not great than 1000");
            }
            if (this.fileHeader.getFileLength() + (long)length >= this.fileSize) {
                this.fileHeader.markFull();
                throw new CapacityNotEnoughException();
            }
            ReadableByteChannel src = Channels.newChannel(new UnsafeByteArrayInputStream(dataBytes));
            long position = this.fileHeader.getFileLength();
            this.fileChannel.transferFrom(src, position, length);
            result.setFileId(this.fileId);
            result.setFromIndex(position);
            result.setLength(length);
            this.fileHeader.setFileLength(this.fileHeader.getFileLength() + (long)length);
            this.fileHeader.getTotalNum().incrementAndGet();
            this.fileHeader.getAliveNum().incrementAndGet();
            this.lastTxLogPosition = txLog;
        }
        return result;
    }

    public boolean isFull() {
        return this.fileHeader.isFull();
    }

    public StoreTxLogPosition getLastTxLogPosition() {
        return new StoreTxLogPosition(this.fileHeader.getStoreTxLogRecordId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(StoreTxLogPosition txLogPosition, long fromIndex, int length) {
        this.fileHeader.getAliveNum().decrementAndGet();
        DataBlock dataBlock = this;
        synchronized (dataBlock) {
            this.lastTxLogPosition = txLogPosition;
        }
    }

    public long getFileId() {
        return this.fileId;
    }

    public byte[] readData(long fromIndex, int length) throws IOException {
        this.fileChannel.position(fromIndex);
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        this.fileChannel.read(byteBuffer);
        return byteBuffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDisk() throws IOException {
        if (this.totalNum == this.fileHeader.getTotalNum().get() && this.aliveNum == this.fileHeader.getAliveNum().get()) {
            return;
        }
        this.totalNum = this.fileHeader.getTotalNum().get();
        this.aliveNum = this.fileHeader.getAliveNum().get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("flush Data start");
        }
        DataBlock dataBlock = this;
        synchronized (dataBlock) {
            this.fileHeader.setStoreTxLogRecordId(this.lastTxLogPosition.getRecordId());
            this.fileChannel.force(true);
        }
        this.fileHeader.write(this.fileChannel);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("flush Data end:" + JSON.toJSONString(this.fileHeader));
        }
    }

    private class FlushDataService
    extends ServiceThread {
        private FlushDataService() {
        }

        @Override
        public String getServiceName() {
            return FlushDataService.class.getSimpleName();
        }

        @Override
        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    if (DataBlock.this.storeConfig.isEnableFlushDataInterval()) {
                        Thread.sleep(DataBlock.this.storeConfig.getFlushDataInterval());
                    } else {
                        this.waitForRunning(DataBlock.this.storeConfig.getFlushDataInterval());
                    }
                    DataBlock.this.flushDisk();
                }
                catch (Exception e) {
                    LOGGER.error(this.getServiceName() + " error:" + e.getMessage(), e);
                }
            }
        }
    }
}

