/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json;

import com.github.ltsopensource.core.json.TypeUtils;
import com.github.ltsopensource.json.JSONException;
import com.github.ltsopensource.json.JSONObject;
import com.github.ltsopensource.json.JSONTokenizer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class JSONArray
implements Iterable<Object> {
    private final ArrayList<Object> list = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(JSONTokenizer x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.list.add(JSONObject.NULL);
                } else {
                    x.back();
                    this.list.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case ',': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x.syntaxError("Expected a ',' or ']'");
        }
    }

    public JSONArray(String source) throws JSONException {
        this(new JSONTokenizer(source));
    }

    public JSONArray(Collection<?> collection) {
        if (collection != null) {
            for (Object o : collection) {
                this.list.add(JSONObject.wrap(o));
            }
        }
    }

    public JSONArray(Object array) throws JSONException {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                this.put(JSONObject.wrap(Array.get(array, i)));
            }
        }
        if (Collection.class.isAssignableFrom(array.getClass())) {
            Collection collection = (Collection)array;
            for (Object o : collection) {
                this.put(JSONObject.wrap(o));
            }
        } else {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    public Object get(int index) throws JSONException {
        return this.opt(index);
    }

    public Object opt(int index) {
        if (index < 0 || index >= this.length()) {
            return null;
        }
        Object value = this.list.get(index);
        if (value == JSONObject.NULL) {
            return null;
        }
        return value;
    }

    public JSONArray getJSONArray(int index) throws JSONException {
        Object object = this.get(index);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) throws JSONException {
        Object object = this.get(index);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public int length() {
        return this.list.size();
    }

    public JSONArray put(Object value) {
        this.list.add(value);
        return this;
    }

    public JSONArray put(int index, Object value) throws JSONException {
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.list.set(index, value);
        } else {
            while (index != this.length()) {
                this.put(JSONObject.NULL);
            }
            this.put(value);
        }
        return this;
    }

    public Object remove(int index) {
        return index >= 0 && index < this.length() ? this.list.remove(index) : null;
    }

    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    public String toString() {
        try {
            return this.write(new StringWriter()).toString();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    Writer write(Writer writer) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.length();
            writer.write(91);
            if (length == 1) {
                JSONObject.writeValue(writer, this.list.get(0));
            } else if (length != 0) {
                for (int i = 0; i < length; ++i) {
                    if (commanate) {
                        writer.write(44);
                    }
                    JSONObject.writeValue(writer, this.list.get(i));
                    commanate = true;
                }
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    public boolean addAll(Collection<?> c) {
        return this.list.addAll(c);
    }

    public boolean addAll(int index, Collection<?> c) {
        return this.list.addAll(index, c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    public void clear() {
        this.list.clear();
    }

    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public ListIterator<Object> listIterator() {
        return this.list.listIterator();
    }

    public ListIterator<Object> listIterator(int index) {
        return this.list.listIterator(index);
    }

    public List<Object> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public <T> T getObject(int index, Class<T> clazz) {
        Object value = this.list.get(index);
        return TypeUtils.castToJavaBean(value, clazz);
    }

    public Boolean getBoolean(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBoolean(value);
    }

    public boolean getBooleanValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return false;
        }
        return TypeUtils.castToBoolean(value);
    }

    public Byte getByte(int index) {
        Object value = this.get(index);
        return TypeUtils.castToByte(value);
    }

    public byte getByteValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToByte(value);
    }

    public Short getShort(int index) {
        Object value = this.get(index);
        return TypeUtils.castToShort(value);
    }

    public short getShortValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToShort(value);
    }

    public Integer getInteger(int index) {
        Object value = this.get(index);
        return TypeUtils.castToInt(value);
    }

    public int getIntValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToInt(value);
    }

    public Long getLong(int index) {
        Object value = this.get(index);
        return TypeUtils.castToLong(value);
    }

    public long getLongValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0L;
        }
        return TypeUtils.castToLong(value);
    }

    public Float getFloat(int index) {
        Object value = this.get(index);
        return TypeUtils.castToFloat(value);
    }

    public float getFloatValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0f;
        }
        return TypeUtils.castToFloat(value).floatValue();
    }

    public Double getDouble(int index) {
        Object value = this.get(index);
        return TypeUtils.castToDouble(value);
    }

    public double getDoubleValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0;
        }
        return TypeUtils.castToDouble(value);
    }

    public BigDecimal getBigDecimal(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBigInteger(value);
    }

    public String getString(int index) {
        Object value = this.get(index);
        return TypeUtils.castToString(value);
    }

    public java.util.Date getDate(int index) {
        Object value = this.get(index);
        return TypeUtils.castToDate(value);
    }

    public Date getSqlDate(int index) {
        Object value = this.get(index);
        return TypeUtils.castToSqlDate(value);
    }

    public Timestamp getTimestamp(int index) {
        Object value = this.get(index);
        return TypeUtils.castToTimestamp(value);
    }
}

