/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support.cluster;

import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.jobtracker.channel.ChannelWrapper;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.domain.TaskTrackerNode;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskTrackerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTrackerManager.class);
    private final ConcurrentHashMap<String, Set<TaskTrackerNode>> NODE_MAP = new ConcurrentHashMap();
    private JobTrackerAppContext appContext;

    public TaskTrackerManager(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public Set<String> getNodeGroups() {
        return this.NODE_MAP.keySet();
    }

    public void addNode(Node node) {
        ChannelWrapper channel = this.appContext.getChannelManager().getChannel(node.getGroup(), node.getNodeType(), node.getIdentity());
        Set<TaskTrackerNode> taskTrackerNodes = this.NODE_MAP.get(node.getGroup());
        if (taskTrackerNodes == null) {
            taskTrackerNodes = new ConcurrentHashSet<TaskTrackerNode>();
            Set<TaskTrackerNode> oldSet = this.NODE_MAP.putIfAbsent(node.getGroup(), taskTrackerNodes);
            if (oldSet != null) {
                taskTrackerNodes = oldSet;
            }
        }
        TaskTrackerNode taskTrackerNode = new TaskTrackerNode(node.getGroup(), node.getThreads(), node.getIdentity(), channel);
        LOGGER.info("Add TaskTracker node:{}", taskTrackerNode);
        taskTrackerNodes.add(taskTrackerNode);
        this.appContext.getExecutableJobQueue().createQueue(node.getGroup());
        this.appContext.getNodeGroupStore().addNodeGroup(NodeType.TASK_TRACKER, node.getGroup());
    }

    public void removeNode(Node node) {
        Set<TaskTrackerNode> taskTrackerNodes = this.NODE_MAP.get(node.getGroup());
        if (taskTrackerNodes != null && taskTrackerNodes.size() != 0) {
            TaskTrackerNode taskTrackerNode = new TaskTrackerNode(node.getIdentity());
            taskTrackerNode.setNodeGroup(node.getGroup());
            LOGGER.info("Remove TaskTracker node:{}", taskTrackerNode);
            taskTrackerNodes.remove(taskTrackerNode);
        }
    }

    public TaskTrackerNode getTaskTrackerNode(String nodeGroup, String identity) {
        Set<TaskTrackerNode> taskTrackerNodes = this.NODE_MAP.get(nodeGroup);
        if (taskTrackerNodes == null || taskTrackerNodes.size() == 0) {
            return null;
        }
        for (TaskTrackerNode taskTrackerNode : taskTrackerNodes) {
            if (!taskTrackerNode.getIdentity().equals(identity)) continue;
            if (taskTrackerNode.getChannel() == null || taskTrackerNode.getChannel().isClosed()) {
                ChannelWrapper channel = this.appContext.getChannelManager().getChannel(taskTrackerNode.getNodeGroup(), NodeType.TASK_TRACKER, taskTrackerNode.getIdentity());
                if (channel == null) continue;
                taskTrackerNode.setChannel(channel);
                LOGGER.info("update node channel , taskTackerNode={}", taskTrackerNode);
                return taskTrackerNode;
            }
            return taskTrackerNode;
        }
        return null;
    }

    public void updateTaskTrackerAvailableThreads(String nodeGroup, String identity, Integer availableThreads, Long timestamp) {
        Set<TaskTrackerNode> taskTrackerNodes = this.NODE_MAP.get(nodeGroup);
        if (taskTrackerNodes != null && taskTrackerNodes.size() != 0) {
            for (TaskTrackerNode trackerNode : taskTrackerNodes) {
                if (!trackerNode.getIdentity().equals(identity) || trackerNode.getTimestamp() != null && trackerNode.getTimestamp() > timestamp) continue;
                trackerNode.setAvailableThread(availableThreads);
                trackerNode.setTimestamp(timestamp);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("\u66f4\u65b0\u8282\u70b9\u7ebf\u7a0b\u6570: {}", trackerNode);
            }
        }
    }
}

