/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support;

import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.DateUtils;
import com.github.ltsopensource.core.exception.LtsRuntimeException;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.NodeShutdownHook;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.support.NonRelyJobUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class NonRelyOnPrevCycleJobScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonRelyOnPrevCycleJobScheduler.class);
    private JobTrackerAppContext appContext;
    private int scheduleIntervalMinute;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledFuture;
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicBoolean start = new AtomicBoolean(false);

    public NonRelyOnPrevCycleJobScheduler(JobTrackerAppContext appContext) {
        this.appContext = appContext;
        this.scheduleIntervalMinute = this.appContext.getConfig().getParameter("jobtracker.nonRelyOnPrevCycleJob.schedule.interval.minute", 10);
        NodeShutdownHook.registerHook(appContext, this.getClass().getSimpleName(), new Callable(){

            @Override
            public void call() throws Exception {
                NonRelyOnPrevCycleJobScheduler.this.stop();
            }
        });
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            return;
        }
        try {
            this.executorService = Executors.newScheduledThreadPool(1, new NamedThreadFactory(NonRelyOnPrevCycleJobScheduler.class.getSimpleName(), true));
            this.scheduledFuture = this.executorService.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: {
                        try {
                            if (!NonRelyOnPrevCycleJobScheduler.this.running.compareAndSet(false, true)) break block5;
                            try {
                                NonRelyOnPrevCycleJobScheduler.this.schedule();
                            }
                            finally {
                                NonRelyOnPrevCycleJobScheduler.this.running.set(false);
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.error("Error On Schedule", t);
                        }
                    }
                }
            }, 10L, (this.scheduleIntervalMinute - 1) * 60, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            LOGGER.error("Scheduler Start Error", t);
        }
    }

    public void stop() {
        if (!this.start.compareAndSet(true, false)) {
            return;
        }
        try {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            if (this.executorService != null) {
                this.executorService.shutdownNow();
                this.executorService = null;
            }
        }
        catch (Throwable t) {
            LOGGER.error("Scheduler Stop Error", t);
        }
    }

    private void schedule() {
        Long lastGenerateTriggerTime;
        List<JobPo> jobPos;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("========= Scheduler start =========");
        }
        Date now = new Date();
        Date checkTime = DateUtils.addMinute(now, 10);
        while (CollectionUtils.sizeOf(jobPos = this.appContext.getCronJobQueue().getNeedGenerateJobPos(checkTime.getTime(), 10)) != 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("========= CronJob size[{}] =========", CollectionUtils.sizeOf(jobPos));
            }
            for (JobPo jobPo : jobPos) {
                lastGenerateTriggerTime = jobPo.getLastGenerateTriggerTime();
                if (lastGenerateTriggerTime == null || lastGenerateTriggerTime == 0L) {
                    lastGenerateTriggerTime = new Date().getTime();
                }
                this.addCronJobForInterval(jobPo, new Date(lastGenerateTriggerTime));
            }
        }
        while (CollectionUtils.sizeOf(jobPos = this.appContext.getRepeatJobQueue().getNeedGenerateJobPos(checkTime.getTime(), 10)) != 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("========= Repeat size[{}] =========", CollectionUtils.sizeOf(jobPos));
            }
            for (JobPo jobPo : jobPos) {
                lastGenerateTriggerTime = jobPo.getLastGenerateTriggerTime();
                if (lastGenerateTriggerTime == null || lastGenerateTriggerTime == 0L) {
                    lastGenerateTriggerTime = new Date().getTime();
                }
                this.addRepeatJobForInterval(jobPo, new Date(lastGenerateTriggerTime));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("========= Scheduler End =========");
        }
    }

    public void addScheduleJobForOneHour(JobPo jobPo) {
        if (jobPo.isCron()) {
            this.addCronJobForInterval(jobPo, new Date());
        } else if (jobPo.isRepeatable()) {
            this.addRepeatJobForInterval(jobPo, new Date());
        } else {
            throw new LtsRuntimeException("Only For Cron Or Repeat Job Now");
        }
    }

    private void addCronJobForInterval(JobPo finalJobPo, Date lastGenerateTime) {
        NonRelyJobUtils.addCronJobForInterval(this.appContext.getExecutableJobQueue(), this.appContext.getCronJobQueue(), this.scheduleIntervalMinute, finalJobPo, lastGenerateTime);
    }

    private void addRepeatJobForInterval(JobPo finalJobPo, Date lastGenerateTime) {
        NonRelyJobUtils.addRepeatJobForInterval(this.appContext.getExecutableJobQueue(), this.appContext.getRepeatJobQueue(), this.scheduleIntervalMinute, finalJobPo, lastGenerateTime);
    }
}

