/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.registry.redis;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.exception.NodeRegistryException;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.registry.FailbackRegistry;
import com.github.ltsopensource.core.registry.NodeRegistryUtils;
import com.github.ltsopensource.core.registry.NotifyEvent;
import com.github.ltsopensource.core.registry.NotifyListener;
import com.github.ltsopensource.core.registry.redis.RedisLock;
import com.github.ltsopensource.core.support.SystemClock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisRegistry
extends FailbackRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisRegistry.class);
    private final Map<String, JedisPool> jedisPools = new ConcurrentHashMap<String, JedisPool>();
    private String clusterName;
    private final ScheduledExecutorService expireExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("LTSRedisRegistryExpireTimer", true));
    private final ScheduledFuture<?> expireFuture;
    private final int expirePeriod;
    private boolean replicate;
    private final int reconnectPeriod;
    private final ConcurrentMap<String, Notifier> notifiers = new ConcurrentHashMap<String, Notifier>();
    private RedisLock lock;
    private ConcurrentHashMap<String, List<String>> cachedNodeMap = new ConcurrentHashMap();
    private volatile String monitorId;
    private volatile boolean redisAvailable = false;

    public RedisRegistry(AppContext appContext) {
        super(appContext);
        String[] addrs;
        Config config = appContext.getConfig();
        this.clusterName = config.getClusterName();
        this.lock = new RedisLock("LTS_CLEAN_LOCK_KEY", config.getIdentity(), 120);
        JedisPoolConfig redisConfig = new JedisPoolConfig();
        String address = NodeRegistryUtils.getRealRegistryAddress(config.getRegistryAddress());
        String cluster = config.getParameter("cluster", "failover");
        if (!"failover".equals(cluster) && !"replicate".equals(cluster)) {
            throw new IllegalArgumentException("Unsupported redis cluster: " + cluster + ". The redis cluster only supported failover or replicate.");
        }
        this.replicate = "replicate".equals(cluster);
        this.reconnectPeriod = config.getParameter("reconnect.period", 3000);
        for (String addr : addrs = address.split(",")) {
            int i = addr.indexOf(58);
            String host = addr.substring(0, i);
            int port = Integer.parseInt(addr.substring(i + 1));
            this.jedisPools.put(addr, new JedisPool((GenericObjectPoolConfig)redisConfig, host, port, 1000));
        }
        this.expirePeriod = config.getParameter("redis.session.timeout", 60000);
        this.expireFuture = this.expireExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    RedisRegistry.this.deferExpired();
                }
                catch (Throwable t) {
                    LOGGER.error("Unexpected exception occur at defer expire time, cause: " + t.getMessage(), t);
                }
            }
        }, this.expirePeriod / 2, this.expirePeriod / 2, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferExpired() {
        for (Map.Entry<String, JedisPool> entry : this.jedisPools.entrySet()) {
            JedisPool jedisPool = entry.getValue();
            try {
                Jedis jedis = jedisPool.getResource();
                try {
                    for (Node node : new HashSet<Node>(this.getRegistered())) {
                        String key = NodeRegistryUtils.getNodeTypePath(this.clusterName, node.getNodeType());
                        if (jedis.hset(key, node.toFullString(), String.valueOf(SystemClock.now() + (long)this.expirePeriod)) != 1L) continue;
                        jedis.publish(key, "register");
                    }
                    if (this.lock.acquire(jedis)) {
                        this.clean(jedis);
                    }
                    if (this.replicate) continue;
                    break;
                }
                finally {
                    jedis.close();
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to write provider heartbeat to redis registry. registry: " + entry.getKey() + ", cause: " + t.getMessage(), t);
            }
        }
    }

    private void clean(Jedis jedis) {
        Set nodeTypePaths = jedis.keys(NodeRegistryUtils.getRootPath(this.appContext.getConfig().getClusterName()) + "/*");
        if (CollectionUtils.isNotEmpty(nodeTypePaths)) {
            for (String nodeTypePath : nodeTypePaths) {
                Set nodePaths = jedis.keys(nodeTypePath);
                if (!CollectionUtils.isNotEmpty(nodePaths)) continue;
                for (String nodePath : nodePaths) {
                    Map nodes = jedis.hgetAll(nodePath);
                    if (!CollectionUtils.isNotEmpty(nodes)) continue;
                    boolean delete = false;
                    long now = SystemClock.now();
                    for (Map.Entry entry : nodes.entrySet()) {
                        String key = (String)entry.getKey();
                        long expire = Long.parseLong((String)entry.getValue());
                        if (expire >= now) continue;
                        jedis.hdel(nodePath, new String[]{key});
                        delete = true;
                        if (!LOGGER.isWarnEnabled()) continue;
                        LOGGER.warn("Delete expired key: " + nodePath + " -> value: " + (String)entry.getKey() + ", expire: " + new Date(expire) + ", now: " + new Date(now));
                    }
                    if (!delete) continue;
                    jedis.publish(nodePath, "unregister");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRegister(Node node) {
        String key = NodeRegistryUtils.getNodeTypePath(this.clusterName, node.getNodeType());
        String expire = String.valueOf(SystemClock.now() + (long)this.expirePeriod);
        boolean success = false;
        Throwable exception = null;
        for (Map.Entry<String, JedisPool> entry : this.jedisPools.entrySet()) {
            JedisPool jedisPool = entry.getValue();
            try {
                Jedis jedis = jedisPool.getResource();
                try {
                    jedis.hset(key, node.toFullString(), expire);
                    jedis.publish(key, "register");
                    success = true;
                    if (this.replicate) continue;
                    break;
                }
                finally {
                    jedis.close();
                }
            }
            catch (Throwable t) {
                exception = new NodeRegistryException("Failed to register node to redis registry. registry: " + entry.getKey() + ", node: " + node + ", cause: " + t.getMessage(), t);
            }
        }
        if (exception != null) {
            if (success) {
                LOGGER.warn(exception.getMessage(), exception);
            } else {
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnRegister(Node node) {
        String key = NodeRegistryUtils.getNodeTypePath(this.clusterName, node.getNodeType());
        boolean success = false;
        Throwable exception = null;
        for (Map.Entry<String, JedisPool> entry : this.jedisPools.entrySet()) {
            JedisPool jedisPool = entry.getValue();
            try {
                Jedis jedis = jedisPool.getResource();
                try {
                    jedis.hdel(key, new String[]{node.toFullString()});
                    jedis.publish(key, "unregister");
                    success = true;
                    if (this.replicate) continue;
                    break;
                }
                finally {
                    jedis.close();
                }
            }
            catch (Throwable t) {
                exception = new NodeRegistryException("Failed to unregister node to redis registry. registry: " + entry.getKey() + ", node: " + node + ", cause: " + t.getMessage(), t);
            }
        }
        if (exception != null) {
            if (success) {
                LOGGER.warn(exception.getMessage(), exception);
            } else {
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSubscribe(Node node, NotifyListener listener) {
        List<NodeType> listenNodeTypes = node.getListenNodeTypes();
        if (CollectionUtils.isEmpty(listenNodeTypes)) {
            return;
        }
        for (NodeType listenNodeType : listenNodeTypes) {
            String listenNodePath = NodeRegistryUtils.getNodeTypePath(this.clusterName, listenNodeType);
            Notifier notifier = (Notifier)this.notifiers.get(listenNodePath);
            if (notifier == null) {
                Notifier newNotifier = new Notifier(listenNodePath);
                this.notifiers.putIfAbsent(listenNodePath, newNotifier);
                notifier = (Notifier)this.notifiers.get(listenNodePath);
                if (notifier == newNotifier) {
                    notifier.start();
                }
            }
            boolean success = false;
            Throwable exception = null;
            for (Map.Entry<String, JedisPool> entry : this.jedisPools.entrySet()) {
                JedisPool jedisPool = entry.getValue();
                try {
                    Jedis jedis = jedisPool.getResource();
                    try {
                        this.doNotify(jedis, Collections.singletonList(listenNodePath), Collections.singletonList(listener));
                        success = true;
                        break;
                    }
                    finally {
                        jedis.close();
                    }
                }
                catch (Throwable t) {
                    exception = new NodeRegistryException("Failed to unregister node to redis registry. registry: " + entry.getKey() + ", node: " + node + ", cause: " + t.getMessage(), t);
                }
            }
            if (exception == null) continue;
            if (success) {
                LOGGER.warn(exception.getMessage(), exception);
                continue;
            }
            throw exception;
        }
    }

    @Override
    protected void doUnsubscribe(Node node, NotifyListener listener) {
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.expireFuture.cancel(true);
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), t);
        }
        try {
            for (Notifier notifier : this.notifiers.values()) {
                notifier.shutdown();
            }
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), t);
        }
        for (Map.Entry entry : this.jedisPools.entrySet()) {
            JedisPool jedisPool = (JedisPool)entry.getValue();
            try {
                jedisPool.destroy();
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to destroy the redis registry client. registry: " + (String)entry.getKey() + ", cause: " + t.getMessage(), t);
            }
        }
    }

    private void doNotify(Jedis jedis, Collection<String> keys, Collection<NotifyListener> listeners) {
        if (CollectionUtils.isEmpty(keys) && CollectionUtils.isEmpty(listeners)) {
            return;
        }
        for (String key : keys) {
            Node node;
            ArrayList<Node> nodes;
            Map values = jedis.hgetAll(key);
            ArrayList currentChildren = values == null ? new ArrayList(0) : new ArrayList(values.keySet());
            List<String> oldChildren = this.cachedNodeMap.get(key);
            List<String> addChildren = CollectionUtils.getLeftDiff(currentChildren, oldChildren);
            List<String> decChildren = CollectionUtils.getLeftDiff(oldChildren, currentChildren);
            if (CollectionUtils.isNotEmpty(addChildren)) {
                nodes = new ArrayList<Node>(addChildren.size());
                for (String child : addChildren) {
                    node = NodeRegistryUtils.parse(child);
                    nodes.add(node);
                }
                for (NotifyListener listener : listeners) {
                    this.notify(NotifyEvent.ADD, nodes, listener);
                }
            }
            if (CollectionUtils.isNotEmpty(decChildren)) {
                nodes = new ArrayList(decChildren.size());
                for (String child : decChildren) {
                    node = NodeRegistryUtils.parse(child);
                    nodes.add(node);
                }
                for (NotifyListener listener : listeners) {
                    this.notify(NotifyEvent.REMOVE, nodes, listener);
                }
            }
            this.cachedNodeMap.put(key, currentChildren);
        }
    }

    private void doNotify(Jedis jedis, String key) {
        for (Map.Entry<Node, Set<NotifyListener>> entry : new HashMap<Node, Set<NotifyListener>>(this.getSubscribed()).entrySet()) {
            this.doNotify(jedis, Collections.singletonList(key), new HashSet<NotifyListener>((Collection)entry.getValue()));
        }
    }

    private class Notifier
    extends Thread {
        private final String listenNodePath;
        private volatile Jedis jedis;
        private volatile boolean running = true;

        public Notifier(String listenNodePath) {
            super.setDaemon(true);
            super.setName("LTSRedisSubscribe");
            this.listenNodePath = listenNodePath;
            if (RedisRegistry.this.monitorId == null) {
                RedisRegistry.this.monitorId = listenNodePath;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (this.running) {
                        int retryTimes = 0;
                        for (Map.Entry entry : RedisRegistry.this.jedisPools.entrySet()) {
                            try {
                                JedisPool jedisPool = (JedisPool)entry.getValue();
                                this.jedis = jedisPool.getResource();
                                if (this.listenNodePath.equals(RedisRegistry.this.monitorId) && !RedisRegistry.this.redisAvailable) {
                                    RedisRegistry.this.redisAvailable = true;
                                    RedisRegistry.this.appContext.getRegistryStatMonitor().setAvailable(RedisRegistry.this.redisAvailable);
                                }
                                try {
                                    retryTimes = 0;
                                    this.jedis.subscribe((JedisPubSub)new NotifySub(jedisPool), new String[]{this.listenNodePath});
                                    continue block7;
                                }
                                finally {
                                    this.jedis.close();
                                    continue block7;
                                }
                            }
                            catch (Throwable t) {
                                LOGGER.warn("Failed to subscribe node from redis registry. registry: " + (String)entry.getKey(), t);
                                if (++retryTimes % RedisRegistry.this.jedisPools.size() != 0) continue;
                                Notifier.sleep(RedisRegistry.this.reconnectPeriod);
                                if (!this.listenNodePath.equals(RedisRegistry.this.monitorId) || !RedisRegistry.this.redisAvailable) continue;
                                RedisRegistry.this.redisAvailable = false;
                                RedisRegistry.this.appContext.getRegistryStatMonitor().setAvailable(RedisRegistry.this.redisAvailable);
                            }
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    LOGGER.error(t.getMessage(), t);
                    break;
                }
            }
        }

        public void shutdown() {
            try {
                this.running = false;
                this.jedis.disconnect();
            }
            catch (Throwable t) {
                LOGGER.warn(t.getMessage(), t);
            }
        }
    }

    private class NotifySub
    extends JedisPubSub {
        private final JedisPool jedisPool;

        public NotifySub(JedisPool jedisPool) {
            this.jedisPool = jedisPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(String key, String msg) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("redis event: " + key + " = " + msg);
            }
            if (msg.equals("register") || msg.equals("unregister")) {
                try {
                    Jedis jedis = this.jedisPool.getResource();
                    try {
                        RedisRegistry.this.doNotify(jedis, key);
                    }
                    finally {
                        jedis.close();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error(t.getMessage(), t);
                }
            }
        }
    }
}

