/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.json.jackson;

import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.json.JSONArray;
import com.github.ltsopensource.core.json.JSONObject;
import com.github.ltsopensource.core.json.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class JacksonJSONArray
implements JSONArray {
    private List<Object> list;

    public JacksonJSONArray() {
        this.list = new ArrayList<Object>(16);
    }

    public JacksonJSONArray(List<Object> list) {
        this.list = list;
    }

    public JacksonJSONArray(int initialCapacity) {
        this.list = new ArrayList<Object>(initialCapacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Object set(int index, Object element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    @Override
    public Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.list.listIterator();
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public JSONObject getJSONObject(int index) {
        Object value = this.list.get(index);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return JSON.toJSONObject(value);
    }

    @Override
    public JSONArray getJSONArray(int index) {
        Object value = this.list.get(index);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return JSON.toJSONArray(value);
    }

    @Override
    public <T> T getObject(int index, Class<T> clazz) {
        Object value = this.list.get(index);
        return TypeUtils.castToJavaBean(value, clazz);
    }

    @Override
    public Boolean getBoolean(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBoolean(value);
    }

    @Override
    public boolean getBooleanValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return false;
        }
        return TypeUtils.castToBoolean(value);
    }

    @Override
    public Byte getByte(int index) {
        Object value = this.get(index);
        return TypeUtils.castToByte(value);
    }

    @Override
    public byte getByteValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToByte(value);
    }

    @Override
    public Short getShort(int index) {
        Object value = this.get(index);
        return TypeUtils.castToShort(value);
    }

    @Override
    public short getShortValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToShort(value);
    }

    @Override
    public Integer getInteger(int index) {
        Object value = this.get(index);
        return TypeUtils.castToInt(value);
    }

    @Override
    public int getIntValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToInt(value);
    }

    @Override
    public Long getLong(int index) {
        Object value = this.get(index);
        return TypeUtils.castToLong(value);
    }

    @Override
    public long getLongValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0L;
        }
        return TypeUtils.castToLong(value);
    }

    @Override
    public Float getFloat(int index) {
        Object value = this.get(index);
        return TypeUtils.castToFloat(value);
    }

    @Override
    public float getFloatValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0f;
        }
        return TypeUtils.castToFloat(value).floatValue();
    }

    @Override
    public Double getDouble(int index) {
        Object value = this.get(index);
        return TypeUtils.castToDouble(value);
    }

    @Override
    public double getDoubleValue(int index) {
        Object value = this.get(index);
        if (value == null) {
            return 0.0;
        }
        return TypeUtils.castToDouble(value);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBigDecimal(value);
    }

    @Override
    public BigInteger getBigInteger(int index) {
        Object value = this.get(index);
        return TypeUtils.castToBigInteger(value);
    }

    @Override
    public String getString(int index) {
        Object value = this.get(index);
        return TypeUtils.castToString(value);
    }

    @Override
    public java.util.Date getDate(int index) {
        Object value = this.get(index);
        return TypeUtils.castToDate(value);
    }

    @Override
    public Date getSqlDate(int index) {
        Object value = this.get(index);
        return TypeUtils.castToSqlDate(value);
    }

    @Override
    public Timestamp getTimestamp(int index) {
        Object value = this.get(index);
        return TypeUtils.castToTimestamp(value);
    }
}

