/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.biz.logger;

import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.biz.logger.JobLogException;
import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.SmartJobLogger;
import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.JobLoggerRequest;
import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.NodeShutdownHook;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LazyJobLogger
implements JobLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartJobLogger.class);
    private JobLogger delegate;
    private BlockingQueue<JobLogPo> memoryQueue = new LinkedBlockingQueue<JobLogPo>();
    private int batchFlushSize;
    private int overflowSize;
    private int maxMemoryLogSize;
    private AtomicBoolean flushing = new AtomicBoolean(false);

    public LazyJobLogger(AppContext appContext, JobLogger delegate) {
        this.delegate = delegate;
        Config config = appContext.getConfig();
        this.maxMemoryLogSize = config.getParameter("lazy.job.logger.mem.size", 1000);
        int flushPeriod = config.getParameter("lazy.job.logger.check.period", 3);
        this.batchFlushSize = config.getParameter("lazy.job.logger.batch.flush.size", 100);
        this.overflowSize = config.getParameter("lazy.job.logger.overflow.size", 10000);
        final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("LazyJobLogger", true));
        final ScheduledFuture<?> scheduledFuture = executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LazyJobLogger.this.flushing.compareAndSet(false, true)) {
                        LazyJobLogger.this.checkAndFlush();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("CheckAndFlush log error", t);
                }
            }
        }, flushPeriod, flushPeriod, TimeUnit.SECONDS);
        NodeShutdownHook.registerHook(appContext, this.getClass().getName(), new Callable(){

            @Override
            public void call() throws Exception {
                scheduledFuture.cancel(true);
                executor.shutdownNow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndFlush() {
        try {
            int nowSize = this.memoryQueue.size();
            if (nowSize == 0) {
                return;
            }
            ArrayList<JobLogPo> batch = new ArrayList<JobLogPo>();
            for (int i = 0; i < nowSize; ++i) {
                JobLogPo jobLogPo = (JobLogPo)this.memoryQueue.poll();
                batch.add(jobLogPo);
                if (batch.size() < this.batchFlushSize) continue;
                this.flush(batch);
            }
            if (batch.size() > 0) {
                this.flush(batch);
            }
        }
        finally {
            this.flushing.compareAndSet(true, false);
        }
    }

    private void checkOverflowSize() {
        if (this.memoryQueue.size() > this.overflowSize) {
            throw new JobLogException("Memory Log size is " + this.memoryQueue.size() + " , please check the JobLogger is available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(List<JobLogPo> batch) {
        boolean flushSuccess = false;
        try {
            this.delegate.log(batch);
            flushSuccess = true;
        }
        finally {
            if (!flushSuccess) {
                this.memoryQueue.addAll(batch);
            }
            batch.clear();
        }
    }

    private void checkCapacity() {
        if (this.memoryQueue.size() > this.maxMemoryLogSize && this.flushing.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LazyJobLogger.this.checkAndFlush();
                    }
                    catch (Throwable t) {
                        LOGGER.error("Capacity full flush error", t);
                    }
                }
            }).start();
        }
    }

    @Override
    public void log(JobLogPo jobLogPo) {
        if (jobLogPo == null) {
            return;
        }
        this.checkOverflowSize();
        this.memoryQueue.offer(jobLogPo);
        this.checkCapacity();
    }

    @Override
    public void log(List<JobLogPo> jobLogPos) {
        if (CollectionUtils.isEmpty(jobLogPos)) {
            return;
        }
        this.checkOverflowSize();
        for (JobLogPo jobLogPo : jobLogPos) {
            this.memoryQueue.offer(jobLogPo);
        }
        this.checkCapacity();
    }

    @Override
    public PaginationRsp<JobLogPo> search(JobLoggerRequest request) {
        return this.delegate.search(request);
    }
}

