/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.alarm.email;

import com.github.ltsopensource.alarm.AbstractAlarmNotifier;
import com.github.ltsopensource.alarm.AlarmNotifyException;
import com.github.ltsopensource.alarm.email.EmailAlarmMessage;
import com.github.ltsopensource.alarm.email.MailManager;
import com.github.ltsopensource.alarm.email.SMTPMailManagerImpl;
import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;

public class EmailAlarmNotifier
extends AbstractAlarmNotifier<EmailAlarmMessage> {
    private MailManager mailManager;

    public EmailAlarmNotifier(AppContext appContext) {
        this.mailManager = this.getMailManager(appContext);
    }

    private MailManager getMailManager(AppContext appContext) {
        Config config = appContext.getConfig();
        String host = config.getParameter("mail.smtp.host");
        String port = config.getParameter("mail.smtp.port");
        String userName = config.getParameter("mail.username");
        String password = config.getParameter("mail.password");
        String adminAddress = config.getParameter("mail.adminAddress");
        boolean sslEnabled = config.getParameter("mail.sslEnabled", true);
        return new SMTPMailManagerImpl(host, port, userName, password, adminAddress, sslEnabled);
    }

    @Override
    protected void doNotice(EmailAlarmMessage message) {
        try {
            this.mailManager.send(message.getTo(), message.getTitle(), message.getMsg());
        }
        catch (Exception e) {
            throw new AlarmNotifyException("EmailAlarmNotifier send error", e);
        }
    }
}

