/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc.builder;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.store.jdbc.SQLFormatter;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.builder.OrderByType;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import com.github.ltsopensource.store.jdbc.dbutils.ResultSetHandler;
import com.github.ltsopensource.store.jdbc.exception.JdbcException;
import java.util.LinkedList;
import java.util.List;

public class SelectSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectSql.class);
    private SqlTemplate sqlTemplate;
    private StringBuilder sql = new StringBuilder();
    private List<Object> params = new LinkedList<Object>();
    private int curOrderByColumnSize = 0;
    private static final String ORDER_BY = " ORDER BY ";

    public SelectSql(SqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public SelectSql select() {
        this.sql.append(" SELECT ");
        return this;
    }

    public SelectSql all() {
        this.sql.append(" * ");
        return this;
    }

    public SelectSql columns(String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new JdbcException("columns must have length");
        }
        String split = "";
        for (String column : columns) {
            this.sql.append(split);
            split = ",";
            this.sql.append(column.trim()).append(" ");
        }
        return this;
    }

    public SelectSql from() {
        this.sql.append(" FROM ");
        return this;
    }

    public SelectSql table(String table) {
        this.sql.append("`").append(table).append("`");
        return this;
    }

    public SelectSql tables(String ... tables) {
        String split = "";
        for (String table : tables) {
            this.sql.append(split);
            split = ",";
            this.sql.append(table.trim()).append(" ");
        }
        return this;
    }

    public SelectSql where() {
        this.sql.append(" WHERE ");
        return this;
    }

    public SelectSql whereSql(WhereSql whereSql) {
        this.sql.append(whereSql.getSQL());
        this.params.addAll(whereSql.params());
        return this;
    }

    public SelectSql where(String condition, Object value) {
        this.sql.append(" WHERE ").append(condition);
        this.params.add(value);
        return this;
    }

    public SelectSql and(String condition, Object value) {
        this.sql.append(" AND ").append(condition);
        this.params.add(value);
        return this;
    }

    public SelectSql or(String condition, Object value) {
        this.sql.append(" OR ").append(condition);
        this.params.add(value);
        return this;
    }

    public SelectSql orderBy() {
        this.curOrderByColumnSize = 0;
        return this;
    }

    public SelectSql column(String column, OrderByType order) {
        if (StringUtils.isEmpty(column) || order == null) {
            return this;
        }
        if (this.curOrderByColumnSize == 0) {
            this.sql.append(ORDER_BY);
        } else if (this.curOrderByColumnSize > 0) {
            this.sql.append(" , ");
        }
        this.sql.append(" ").append(column).append(" ").append((Object)order);
        ++this.curOrderByColumnSize;
        return this;
    }

    public SelectSql and(String condition) {
        this.sql.append(" AND ").append(condition);
        return this;
    }

    public SelectSql or(String condition) {
        this.sql.append(" OR ").append(condition);
        return this;
    }

    public SelectSql andOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.and(condition, value);
    }

    public SelectSql orOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.or(condition, value);
    }

    public SelectSql andOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.and(condition, value);
    }

    public SelectSql orOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.or(condition, value);
    }

    public SelectSql andBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (start != null && end != null) {
            this.sql.append(" ADN (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(" ").append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append("").append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public SelectSql orBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (start != null && end != null) {
            this.sql.append(" OR (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public SelectSql limit(int start, int size) {
        this.sql.append(" LIMIT ").append(start).append(",").append(size);
        return this;
    }

    public SelectSql groupBy(String ... columns) {
        this.sql.append(" GROUP BY ");
        String split = "";
        for (String column : columns) {
            this.sql.append(split);
            split = ",";
            this.sql.append(column.trim()).append(" ");
        }
        return this;
    }

    public SelectSql having(String condition) {
        this.sql.append(" HAVING ").append(condition);
        return this;
    }

    public SelectSql innerJoin(String condition) {
        this.sql.append(" INNER JOIN ").append(condition);
        return this;
    }

    public SelectSql rightOuterJoin(String condition) {
        this.sql.append(" RIGHT OUTER JOIN ").append(condition);
        return this;
    }

    public SelectSql leftOuterJoin(String condition) {
        this.sql.append(" LEFT OUTER JOIN ").append(condition);
        return this;
    }

    public <T> List<T> list(ResultSetHandler<List<T>> handler) {
        try {
            return this.sqlTemplate.query(this.getSQL(), handler, this.params.toArray());
        }
        catch (Exception e) {
            throw new JdbcException("Select SQL Error:" + this.getSQL(), e);
        }
    }

    public <T> T single(ResultSetHandler<T> handler) {
        try {
            return this.sqlTemplate.query(this.getSQL(), handler, this.params.toArray());
        }
        catch (Exception e) {
            throw new JdbcException("Select SQL Error:" + this.getSQL(), e);
        }
    }

    public <T> T single() {
        String finalSQL = this.getSQL();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(SQLFormatter.format(finalSQL));
            }
            return this.sqlTemplate.queryForValue(finalSQL, this.params.toArray());
        }
        catch (Exception e) {
            throw new JdbcException("Select SQL Error:" + SQLFormatter.format(finalSQL), e);
        }
    }

    public String getSQL() {
        return this.sql.toString();
    }
}

