/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc.builder;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.store.jdbc.SQLFormatter;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import com.github.ltsopensource.store.jdbc.exception.JdbcException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class DeleteSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteSql.class);
    private SqlTemplate sqlTemplate;
    private StringBuilder sql = new StringBuilder();
    private List<Object> params = new LinkedList<Object>();

    public DeleteSql(SqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public DeleteSql delete() {
        this.sql.append(" DELETE ");
        return this;
    }

    public DeleteSql all() {
        this.sql.append(" * ");
        return this;
    }

    public DeleteSql from() {
        this.sql.append(" FROM ");
        return this;
    }

    public DeleteSql table(String table) {
        this.sql.append(" `").append(table.trim()).append("` ");
        return this;
    }

    public DeleteSql where() {
        this.sql.append(" WHERE ");
        return this;
    }

    public DeleteSql whereSql(WhereSql whereSql) {
        this.sql.append(whereSql.getSQL());
        this.params.addAll(whereSql.params());
        return this;
    }

    public DeleteSql where(String condition, Object value) {
        this.sql.append(" WHERE ").append(condition);
        this.params.add(value);
        return this;
    }

    public DeleteSql and(String condition, Object value) {
        this.sql.append(" AND ").append(condition);
        this.params.add(value);
        return this;
    }

    public DeleteSql or(String condition, Object value) {
        this.sql.append(" OR ").append(condition);
        this.params.add(value);
        return this;
    }

    public DeleteSql and(String condition) {
        this.sql.append(" AND ").append(condition);
        return this;
    }

    public DeleteSql or(String condition) {
        this.sql.append(" OR ").append(condition);
        return this;
    }

    public DeleteSql andOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.and(condition, value);
    }

    public DeleteSql orOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.or(condition, value);
    }

    public DeleteSql andOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.and(condition, value);
    }

    public DeleteSql orOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.or(condition, value);
    }

    public DeleteSql andBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (start != null && end != null) {
            this.sql.append(" ADN (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public DeleteSql orBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (start != null && end != null) {
            this.sql.append(" OR (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public int doDelete() {
        String finalSQL = this.getSQL();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(SQLFormatter.format(finalSQL));
            }
            return this.sqlTemplate.delete(finalSQL, this.params.toArray());
        }
        catch (SQLException e) {
            throw new JdbcException("Delete SQL Error:" + SQLFormatter.format(finalSQL), e);
        }
    }

    public String getSQL() {
        return this.sql.toString();
    }
}

