/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.iterator;

import com.github.ltsopensource.kv.Entry;
import com.github.ltsopensource.kv.cache.DataCache;
import com.github.ltsopensource.kv.data.DataBlockEngine;
import com.github.ltsopensource.kv.index.IndexItem;
import com.github.ltsopensource.kv.index.MemIndex;
import com.github.ltsopensource.kv.iterator.DBIterator;
import java.util.Iterator;
import java.util.Map;

public class MemIteratorImpl<K, V>
implements DBIterator<Entry<K, V>> {
    private Iterator<Map.Entry<K, IndexItem<K>>> iterator;
    private DataBlockEngine<K, V> dataBlockEngine;
    private DataCache<K, V> dataCache;
    private MemIndex<K, V> index;

    public MemIteratorImpl(MemIndex<K, V> index, DataBlockEngine<K, V> dataBlockEngine, DataCache<K, V> dataCache) {
        this.index = index;
        this.dataBlockEngine = dataBlockEngine;
        this.dataCache = dataCache;
        this.iterator = index.getIndexMap().entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Entry<K, V> next() {
        Map.Entry<K, IndexItem<K>> entry = this.iterator.next();
        IndexItem<K> index = entry.getValue();
        V value = this.dataCache.get(index.getKey());
        if (value != null) {
            return new Entry<K, V>(entry.getKey(), value);
        }
        value = this.dataBlockEngine.getValue(index);
        if (value == null) {
            return null;
        }
        return new Entry<K, V>(entry.getKey(), value);
    }
}

