/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json.deserializer;

import com.github.ltsopensource.json.JSONException;
import com.github.ltsopensource.json.deserializer.Deserializer;
import java.lang.reflect.Type;

public class EnumDeserializer
implements Deserializer {
    private Class<?> enumType;

    public EnumDeserializer(Class<?> enumType) {
        this.enumType = enumType;
    }

    @Override
    public <T> T deserialize(Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isEnum()) {
            return (T)object;
        }
        if (!(object instanceof String)) {
            throw new JSONException("enum object:[" + object + "] is invalid");
        }
        return (T)Enum.valueOf(this.enumType, object.toString());
    }
}

