/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.PrimitiveTypeUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.json.TypeUtils;
import com.github.ltsopensource.json.JSONArray;
import com.github.ltsopensource.json.JSONException;
import com.github.ltsopensource.json.JSONParser;
import com.github.ltsopensource.json.JSONTokenizer;
import com.github.ltsopensource.json.bean.MethodInfo;
import com.github.ltsopensource.json.deserializer.PrimitiveTypeDeserializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JSONObject {
    private final Map<String, Object> map = new HashMap<String, Object>();
    private static final ConcurrentMap<Class<?>, Set<MethodInfo>> METHOD_MAP = new ConcurrentHashMap();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(JSONTokenizer x) throws JSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map<?, ?> map) {
        if (map != null) {
            for (Map.Entry<?, ?> e : map.entrySet()) {
                Object value = e.getValue();
                if (value == null) continue;
                this.map.put(String.valueOf(e.getKey()), JSONObject.wrap(value));
            }
        }
    }

    public JSONObject(Object bean) {
        this();
        if (Map.class.isAssignableFrom(bean.getClass())) {
            for (Map.Entry entry : ((Map)bean).entrySet()) {
                this.map.put(entry.getKey().toString(), JSONObject.wrap(entry.getValue()));
            }
        } else {
            this.populateMap(bean);
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokenizer(source));
    }

    public Object get(String key) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        return this.opt(key);
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + this.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + this.quote(key) + "] is not a JSONObject.");
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public Iterator<String> keys() {
        return this.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    private static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String key) {
        if (key == null) {
            return null;
        }
        Object value = this.map.get(key);
        if (value == NULL) {
            return null;
        }
        return value;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            this.map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new JSONException("Duplicate key \"" + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    private String quote(String string) {
        StringWriter sw = new StringWriter();
        try {
            return JSONObject.quote(string, sw).toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    private void populateMap(Object bean) {
        Class<?> clazz = bean.getClass();
        Set<MethodInfo> methodInfos = JSONObject.getGetterMethodInfo(clazz);
        if (CollectionUtils.isNotEmpty(methodInfos)) {
            for (MethodInfo methodInfo : methodInfos) {
                try {
                    Object result = methodInfo.getMethod().invoke(bean, (Object[])null);
                    if (result == null) continue;
                    this.map.put(methodInfo.getFieldName(), JSONObject.wrap(result));
                }
                catch (Exception ignored) {}
            }
        }
    }

    private static Set<MethodInfo> getGetterMethodInfo(Class<?> clazz) {
        HashSet<MethodInfo> methodInfos = (HashSet<MethodInfo>)METHOD_MAP.get(clazz);
        if (methodInfos == null) {
            Method[] methods;
            methodInfos = new HashSet<MethodInfo>();
            boolean includeSuperClass = clazz.getClassLoader() != null;
            for (Method method : methods = includeSuperClass ? clazz.getMethods() : clazz.getDeclaredMethods()) {
                try {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    String name = method.getName();
                    String key = "";
                    if (name.startsWith("get")) {
                        key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                    } else if (name.startsWith("is")) {
                        key = name.substring(2);
                    }
                    if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                    if (key.length() == 1) {
                        key = key.toLowerCase();
                    } else if (!Character.isUpperCase(key.charAt(1))) {
                        key = key.substring(0, 1).toLowerCase() + key.substring(1);
                    }
                    methodInfos.add(new MethodInfo(key, method));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            METHOD_MAP.putIfAbsent(clazz, methodInfos);
        }
        return methodInfos;
    }

    private static Writer quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public String toString() {
        try {
            StringWriter w = new StringWriter();
            return this.write(w).toString();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    protected static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof BigInteger || object instanceof BigDecimal) {
                return object;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return new JSONArray(coll);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return new JSONObject(map);
            }
            if (object.getClass().isEnum()) {
                return ((Enum)object).name();
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    static Writer writeValue(Writer writer, Object value) throws JSONException, IOException {
        if (value == null) {
            writer.write("null");
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            new JSONObject(map).write(writer);
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            new JSONArray(coll).write(writer);
        } else if (value.getClass().isArray()) {
            new JSONArray(value).write(writer);
        } else if (value instanceof Number) {
            writer.write(JSONObject.numberToString((Number)value));
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else {
            JSONObject.quote(value.toString(), writer);
        }
        return writer;
    }

    private Writer write(Writer writer) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.size();
            Iterator<String> keys = this.keys();
            writer.write(123);
            if (length == 1) {
                String key = keys.next();
                writer.write(this.quote(key));
                writer.write(58);
                JSONObject.writeValue(writer, this.map.get(key));
            } else if (length != 0) {
                while (keys.hasNext()) {
                    String key = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    writer.write(this.quote(key));
                    writer.write(58);
                    JSONObject.writeValue(writer, this.map.get(key));
                    commanate = true;
                }
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        Object value = this.map.get(key);
        return TypeUtils.castToJavaBean(value, clazz);
    }

    public Boolean getBoolean(String key) {
        Object value = this.map.get(key);
        return TypeUtils.castToBoolean(value);
    }

    public byte[] getBytes(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBytes(value);
    }

    public boolean getBooleanValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return false;
        }
        return TypeUtils.castToBoolean(key);
    }

    public Byte getByte(String key) {
        Object value = this.get(key);
        return TypeUtils.castToByte(value);
    }

    public byte getByteValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToByte(value);
    }

    public Short getShort(String key) {
        Object value = this.get(key);
        return TypeUtils.castToShort(value);
    }

    public short getShortValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToShort(value);
    }

    public Integer getInteger(String key) {
        Object value = this.get(key);
        return TypeUtils.castToInt(value);
    }

    public int getIntValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToInt(value);
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        return TypeUtils.castToLong(value);
    }

    public long getLongValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0L;
        }
        return TypeUtils.castToLong(value);
    }

    public Float getFloat(String key) {
        Object value = this.get(key);
        return TypeUtils.castToFloat(value);
    }

    public float getFloatValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0.0f;
        }
        return TypeUtils.castToFloat(value).floatValue();
    }

    public Double getDouble(String key) {
        Object value = this.get(key);
        return TypeUtils.castToDouble(value);
    }

    public double getDoubleValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0.0;
        }
        return TypeUtils.castToDouble(value);
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = this.get(key);
        return TypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(String key) {
        Object value = this.get(key);
        return TypeUtils.castToBigInteger(value);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public java.util.Date getDate(String key) {
        Object value = this.get(key);
        return TypeUtils.castToDate(value);
    }

    public Date getSqlDate(String key) {
        Object value = this.get(key);
        return TypeUtils.castToSqlDate(value);
    }

    public Timestamp getTimestamp(String key) {
        Object value = this.get(key);
        return TypeUtils.castToTimestamp(value);
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public void putAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
    }

    public static <T> T parseObject(String json, Type type) {
        if (PrimitiveTypeUtils.isPrimitiveType(type)) {
            return new PrimitiveTypeDeserializer().deserialize(json, type);
        }
        Object object = null;
        if (StringUtils.isEmpty(json)) {
            throw new JSONException("illegal json: json is empty");
        }
        if ((json = json.trim()).startsWith("{")) {
            object = new JSONObject(json);
        } else if (json.startsWith("[")) {
            object = new JSONArray(json);
        } else {
            throw new JSONException("illegal json:" + json);
        }
        return JSONParser.parse(object, type);
    }

    public static String toJSONString(Object obj) {
        if (JSONObject.isJSONArray(obj.getClass())) {
            return new JSONArray(obj).toString();
        }
        return new JSONObject(obj).toString();
    }

    private static boolean isJSONArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        return Collection.class.isAssignableFrom(clazz);
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

