/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.spi;

import com.github.ltsopensource.core.commons.utils.Assert;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ClassLoaderUtil {
    private static final ConstructorCache CONSTRUCTOR_CACHE = new ConstructorCache();

    private ClassLoaderUtil() {
    }

    public static <T> T newInstance(ClassLoader classLoader, String className) throws Exception {
        Constructor constructor = CONSTRUCTOR_CACHE.get(classLoader = classLoader == null ? ClassLoaderUtil.class.getClassLoader() : classLoader, className);
        if (constructor != null) {
            return constructor.newInstance(new Object[0]);
        }
        Class<?> clazz = ClassLoaderUtil.loadClass(classLoader, className);
        return (T)ClassLoaderUtil.newInstance(clazz, classLoader, className);
    }

    public static <T> T newInstance(Class<T> clazz, ClassLoader classLoader, String className) throws Exception {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        ClassLoaderUtil.CONSTRUCTOR_CACHE.put(classLoader, className, constructor);
        return constructor.newInstance(new Object[0]);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Assert.notNull(className, "className");
        ClassLoader theClassLoader = classLoader;
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            try {
                return ClassLoaderUtil.tryLoadClass(className, theClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(className);
    }

    private static Class<?> tryLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.startsWith("[")) {
            return Class.forName(className, false, classLoader);
        }
        return classLoader.loadClass(className);
    }

    private static final class ConstructorCache {
        private final ConcurrentMap<ClassLoader, ConcurrentMap<String, WeakReference<Constructor>>> cache = new ConcurrentHashMap<ClassLoader, ConcurrentMap<String, WeakReference<Constructor>>>();

        private ConstructorCache() {
        }

        private <T> Constructor put(ClassLoader classLoader, String className, Constructor<T> constructor) {
            ConcurrentMap old;
            ClassLoader cl = classLoader == null ? ClassLoaderUtil.class.getClassLoader() : classLoader;
            ConcurrentMap<String, WeakReference<Constructor<Object>>> innerCache = (ConcurrentHashMap<String, WeakReference<Constructor<T>>>)this.cache.get(cl);
            if (innerCache == null && (old = (ConcurrentMap)this.cache.putIfAbsent(cl, innerCache = new ConcurrentHashMap<String, WeakReference<Constructor<T>>>(100))) != null) {
                innerCache = old;
            }
            innerCache.put(className, new WeakReference<Constructor<T>>(constructor));
            return constructor;
        }

        public <T> Constructor<T> get(ClassLoader classLoader, String className) {
            Constructor constructor;
            Assert.notNull(className, "className");
            ConcurrentMap innerCache = (ConcurrentMap)this.cache.get(classLoader);
            if (innerCache == null) {
                return null;
            }
            WeakReference reference = (WeakReference)innerCache.get(className);
            Constructor constructor2 = constructor = reference == null ? null : (Constructor)reference.get();
            if (reference != null && constructor == null) {
                innerCache.remove(className);
            }
            return constructor;
        }
    }
}

