/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.registry;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.registry.Registry;
import com.github.ltsopensource.core.registry.redis.RedisRegistry;
import com.github.ltsopensource.core.registry.zookeeper.ZookeeperRegistry;

public class RegistryFactory {
    public static Registry getRegistry(AppContext appContext) {
        String address = appContext.getConfig().getRegistryAddress();
        if (StringUtils.isEmpty(address)) {
            throw new IllegalArgumentException("address is null\uff01");
        }
        if (address.startsWith("zookeeper://")) {
            return new ZookeeperRegistry(appContext);
        }
        if (address.startsWith("redis://")) {
            return new RedisRegistry(appContext);
        }
        if (address.startsWith("multicast://")) {
            // empty if block
        }
        throw new IllegalArgumentException("illegal address protocol");
    }
}

