/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.protocol;

public class JobProtos {
    private JobProtos() {
    }

    public static enum ResponseCode {
        JOB_IN_PROGRESS(10),
        JOB_RECEIVE_SUCCESS(11),
        JOB_RECEIVE_FAILED(12),
        JOB_RUN_FAILURE(13),
        NO_TASK_TRACKER(15),
        HEART_BEAT_SUCCESS(16),
        NO_NODE_GROUP(17),
        NO_AVAILABLE_JOB_RUNNER(18),
        JOB_PUSH_SUCCESS(19),
        JOB_NOTIFY_SUCCESS(20),
        JOB_PULL_SUCCESS(21),
        BIZ_LOG_SEND_SUCCESS(22),
        JOB_CANCEL_SUCCESS(23),
        JOB_CANCEL_FAILED(24),
        JOB_RUN_ERROR(25);

        private int code;

        private ResponseCode(int code) {
            this.code = code;
        }

        public static ResponseCode valueOf(int code) {
            for (ResponseCode responseCode : ResponseCode.values()) {
                if (responseCode.code != code) continue;
                return responseCode;
            }
            throw new IllegalArgumentException("can't find the response code !");
        }

        public int code() {
            return this.code;
        }
    }

    public static enum RequestCode {
        HEART_BEAT(10),
        SUBMIT_JOB(11),
        ASK_JOB_PROGRESS(12),
        PUSH_JOB(13),
        JOB_COMPLETED(14),
        JOB_ASK(15),
        JOB_PULL(16),
        BIZ_LOG_SEND(17),
        CANCEL_JOB(18),
        SUBMIT_DEP_JOB_GROUP(19);

        private int code;

        private RequestCode(int code) {
            this.code = code;
        }

        public static RequestCode valueOf(int code) {
            for (RequestCode requestCode : RequestCode.values()) {
                if (requestCode.code != code) continue;
                return requestCode;
            }
            throw new IllegalArgumentException("can't find the request code !");
        }

        public int code() {
            return this.code;
        }
    }
}

