/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.listener;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.listener.NodeChangeListener;
import java.util.ArrayList;
import java.util.List;

public class MasterElectionListener
implements NodeChangeListener {
    private AppContext appContext;

    public MasterElectionListener(AppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public void removeNodes(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        ArrayList<Node> groupNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!this.isSameGroup(node)) continue;
            groupNodes.add(node);
        }
        if (groupNodes.size() > 0) {
            this.appContext.getMasterElector().removeNode(groupNodes);
        }
    }

    @Override
    public void addNodes(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        ArrayList<Node> groupNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!this.isSameGroup(node)) continue;
            groupNodes.add(node);
        }
        if (groupNodes.size() > 0) {
            this.appContext.getMasterElector().addNodes(groupNodes);
        }
    }

    private boolean isSameGroup(Node node) {
        return node.getNodeType().equals((Object)this.appContext.getConfig().getNodeType()) && node.getGroup().equals(this.appContext.getConfig().getNodeGroup());
    }
}

