/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.groovy;

import com.github.ltsopensource.core.groovy.GroovyException;
import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Method;

public class GroovyEngine {
    private GroovyEngine() {
    }

    public static Class parseClass(String groovySource) throws GroovyException {
        GroovyClassLoader loader = new GroovyClassLoader();
        ClassLoader contextClassLoader = null;
        try {
            contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(null);
            }
            Class clazz = loader.parseClass(groovySource);
            return clazz;
        }
        catch (Throwable t) {
            throw new GroovyException("parseClass error:", t);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public static Object newInstance(String groovySource, Class<?>[] parameterTypes, Object[] args) throws GroovyException {
        Class groovyClass = GroovyEngine.parseClass(groovySource);
        try {
            if (parameterTypes == null || parameterTypes.length == 0) {
                return groovyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return groovyClass.getConstructor(parameterTypes).newInstance(args);
        }
        catch (Throwable t) {
            throw new GroovyException("newInstance error:", t);
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws GroovyException {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (Throwable t) {
            throw new GroovyException("Get Method " + name + " error:", t);
        }
    }

    public static Object invokeMethod(Object obj, Method m, Object ... args) throws GroovyException {
        try {
            return m.invoke(obj, args);
        }
        catch (Throwable t) {
            throw new GroovyException("Invoke Method " + m.getName() + " error:", t);
        }
    }

    public static Object invokeMethod(Object obj, Class<?> clazz, String name, Class<?>[] parameterTypes, Object[] args) throws GroovyException {
        try {
            Method method = null;
            method = parameterTypes == null ? GroovyEngine.getMethod(clazz, name, new Class[0]) : GroovyEngine.getMethod(clazz, name, parameterTypes);
            if (args == null) {
                return method.invoke(obj, new Object[0]);
            }
            return method.invoke(obj, args);
        }
        catch (Throwable t) {
            throw new GroovyException("Invoke Method " + name + " error:", t);
        }
    }
}

