/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.failstore.berkeleydb;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.Pair;
import com.github.ltsopensource.core.failstore.AbstractFailStore;
import com.github.ltsopensource.core.failstore.FailStoreException;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class BerkeleydbFailStore
extends AbstractFailStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BerkeleydbFailStore.class);
    private Environment environment;
    private Database db;
    private EnvironmentConfig envConfig;
    private DatabaseConfig dbConfig;
    public static final String name = "berkeleydb";

    public BerkeleydbFailStore(File dbPath, boolean needLock) {
        super(dbPath, needLock);
    }

    @Override
    protected void init() throws FailStoreException {
        try {
            this.envConfig = new EnvironmentConfig();
            this.envConfig.setAllowCreate(true);
            this.envConfig.setReadOnly(false);
            this.envConfig.setTransactional(true);
            this.envConfig.setDurability(Durability.COMMIT_SYNC);
            this.dbConfig = new DatabaseConfig();
            this.dbConfig.setAllowCreate(true);
            this.dbConfig.setSortedDuplicates(false);
            this.dbConfig.setTransactional(true);
        }
        catch (DatabaseException e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void open() throws FailStoreException {
        try {
            this.environment = new Environment(this.dbPath, this.envConfig);
            this.db = this.environment.openDatabase(null, "lts", this.dbConfig);
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void put(String key, Object value) throws FailStoreException {
        try {
            String valueString = JSON.toJSONString(value);
            OperationStatus status = this.db.put(null, new DatabaseEntry(key.getBytes("UTF-8")), new DatabaseEntry(valueString.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void delete(String key) throws FailStoreException {
        try {
            DatabaseEntry delKey = new DatabaseEntry();
            delKey.setData(key.getBytes("UTF-8"));
            OperationStatus operationStatus = this.db.delete(null, delKey);
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void delete(List<String> keys) throws FailStoreException {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        for (String key : keys) {
            this.delete(key);
        }
    }

    @Override
    public <T> List<Pair<String, T>> fetchTop(int size, Type type) throws FailStoreException {
        Cursor cursor = null;
        try {
            ArrayList<Pair<String, T>> list = new ArrayList<Pair<String, T>>();
            cursor = this.db.openCursor(null, CursorConfig.DEFAULT);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundValue = new DatabaseEntry();
            while (cursor.getNext(foundKey, foundValue, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String key = new String(foundKey.getData(), "UTF-8");
                String valueString = new String(foundValue.getData(), "UTF-8");
                Object value = JSON.parse(valueString, type);
                Pair pair = new Pair(key, value);
                list.add(pair);
                if (list.size() < size) continue;
                break;
            }
            ArrayList<Pair<String, T>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (DatabaseException e) {
                    LOGGER.warn("close cursor failed! ", e);
                }
            }
        }
    }

    @Override
    public void close() throws FailStoreException {
        try {
            if (this.db != null) {
                this.db.close();
            }
            if (this.environment != null && this.environment.isValid()) {
                this.environment.cleanLog();
                this.environment.close();
            }
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void destroy() throws FailStoreException {
        try {
            if (this.environment != null) {
                this.environment.removeDatabase(null, this.db.getDatabaseName());
                this.environment.close();
            }
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
        finally {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            FileUtils.delete(this.dbPath);
        }
    }

    @Override
    protected String getName() {
        return name;
    }
}

