/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.utils;

public class PlatformUtils {
    private static final String OPERATING_SYSTEM = PlatformUtils._getOperatingSystem();
    private static final boolean isWindows = "windows".equals(OPERATING_SYSTEM);
    private static final boolean isOSX = "osx".equals(OPERATING_SYSTEM);
    private static final boolean isLinux = "linux".equals(OPERATING_SYSTEM);

    public static String getOperatingSystem() {
        return OPERATING_SYSTEM;
    }

    private static String _getOperatingSystem() {
        String name = System.getProperty("os.name").toLowerCase().trim();
        if (name.startsWith("linux")) {
            return "linux";
        }
        if (name.startsWith("mac os x")) {
            return "osx";
        }
        if (name.startsWith("win")) {
            return "windows";
        }
        return name.replaceAll("\\W+", "_");
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isOSX() {
        return isOSX;
    }

    public static boolean isLinux() {
        return isLinux;
    }
}

